/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.segment.column.RowSignature;

@JsonTypeName(value="external")
public class ExternalInputSpec
implements InputSpec {
    private final InputSource inputSource;
    private final InputFormat inputFormat;
    private final RowSignature signature;

    @JsonCreator
    public ExternalInputSpec(@JsonProperty(value="inputSource") InputSource inputSource, @JsonProperty(value="inputFormat") InputFormat inputFormat, @JsonProperty(value="signature") RowSignature signature) {
        this.inputSource = (InputSource)Preconditions.checkNotNull((Object)inputSource, (Object)"inputSource");
        this.inputFormat = inputFormat;
        this.signature = (RowSignature)Preconditions.checkNotNull((Object)signature, (Object)"signature");
        if (inputSource.needsFormat()) {
            Preconditions.checkNotNull((Object)inputFormat, (Object)"inputFormat");
        }
    }

    @JsonProperty
    public InputSource getInputSource() {
        return this.inputSource;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InputFormat getInputFormat() {
        return this.inputFormat;
    }

    @JsonProperty
    public RowSignature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalInputSpec that = (ExternalInputSpec)o;
        return Objects.equals(this.inputSource, that.inputSource) && Objects.equals(this.inputFormat, that.inputFormat) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.inputSource, this.inputFormat, this.signature);
    }

    public String toString() {
        return "ExternalInputSpec{inputSources=" + String.valueOf(this.inputSource) + ", inputFormat=" + String.valueOf(this.inputFormat) + ", signature=" + String.valueOf(this.signature) + "}";
    }
}

