/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical.stages;

import java.util.List;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.logical.LogicalInputSpec;
import org.apache.druid.msq.logical.stages.AbstractShuffleStage;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;

public class SortStage
extends AbstractShuffleStage {
    protected final List<KeyColumn> keyColumns;

    public SortStage(LogicalStage inputStage, List<KeyColumn> keyColumns) {
        super(QueryKitUtils.sortableSignature(inputStage.getLogicalRowSignature(), keyColumns), LogicalInputSpec.of(inputStage));
        this.keyColumns = keyColumns;
    }

    @Override
    public RowSignature getLogicalRowSignature() {
        return ((LogicalInputSpec)this.inputSpecs.get(0)).getRowSignature();
    }

    @Override
    public ShuffleSpec buildShuffleSpec() {
        ClusterBy clusterBy = new ClusterBy(this.keyColumns, 0);
        return ShuffleSpecFactories.globalSortWithMaxPartitionCount(1).build(clusterBy, false);
    }

    @Override
    public LogicalStage extendWith(DruidQueryGenerator.DruidNodeStack stack) {
        return null;
    }
}

