/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.rpc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.channel.ChannelClosedForWritesException;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.file.FrameFileHttpResponseHandler;
import org.apache.druid.frame.file.FrameFilePartialFetch;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.indexing.client.SketchResponseHandler;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.rpc.SketchEncoding;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public abstract class BaseWorkerClientImpl
implements WorkerClient {
    private static final Logger log = new Logger(BaseWorkerClientImpl.class);
    private final ObjectMapper objectMapper;
    private final String contentType;

    protected BaseWorkerClientImpl(ObjectMapper objectMapper, String contentType) {
        this.objectMapper = objectMapper;
        this.contentType = contentType;
    }

    @Nonnull
    public static String getStagePartitionPath(StageId stageId, int partitionNumber) {
        return StringUtils.format((String)"/channels/%s/%d/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber(), partitionNumber});
    }

    @Override
    public ListenableFuture<Void> postWorkOrder(String workerId, WorkOrder workOrder) {
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, "/workOrder").objectContent(this.objectMapper, this.contentType, (Object)workOrder), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<ClusterByStatisticsSnapshot> fetchClusterByStatisticsSnapshot(String workerId, StageId stageId, SketchEncoding sketchEncoding) {
        String path = StringUtils.format((String)"/keyStatistics/%s/%d?sketchEncoding=%s", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber(), sketchEncoding});
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, path), (HttpResponseHandler)new SketchResponseHandler(this.objectMapper));
    }

    @Override
    public ListenableFuture<ClusterByStatisticsSnapshot> fetchClusterByStatisticsSnapshotForTimeChunk(String workerId, StageId stageId, long timeChunk, SketchEncoding sketchEncoding) {
        String path = StringUtils.format((String)"/keyStatisticsForTimeChunk/%s/%d/%d?sketchEncoding=%s", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber(), timeChunk, sketchEncoding});
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, path), (HttpResponseHandler)new SketchResponseHandler(this.objectMapper));
    }

    @Override
    public ListenableFuture<Void> postResultPartitionBoundaries(String workerId, StageId stageId, ClusterByPartitions partitionBoundaries) {
        String path = StringUtils.format((String)"/resultPartitionBoundaries/%s/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber()});
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, path).objectContent(this.objectMapper, this.contentType, (Object)partitionBoundaries), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<Void> postCleanupStage(String workerId, StageId stageId) {
        String path = StringUtils.format((String)"/cleanupStage/%s/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber()});
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, path), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<Void> postFinish(String workerId) {
        return this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.POST, "/finish"), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<CounterSnapshotsTree> getCounters(String workerId) {
        return FutureUtils.transform((ListenableFuture)this.getClient(workerId).asyncRequest(new RequestBuilder(HttpMethod.GET, "/counters").header("Accept", this.contentType), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (TypeReference)new TypeReference<CounterSnapshotsTree>(){}));
    }

    @Override
    public ListenableFuture<Boolean> fetchChannelData(String workerId, StageId stageId, int partitionNumber, long offset, final ReadableByteChunksFrameChannel channel) {
        ServiceClient client = this.getClient(workerId);
        String path = BaseWorkerClientImpl.getStagePartitionPath(stageId, partitionNumber);
        final SettableFuture retVal = SettableFuture.create();
        ListenableFuture clientFuture = client.asyncRequest(new RequestBuilder(HttpMethod.GET, StringUtils.format((String)"%s?offset=%d", (Object[])new Object[]{path, offset})).header("Accept-Encoding", "identity"), (HttpResponseHandler)new FrameFileHttpResponseHandler(channel));
        Futures.addCallback((ListenableFuture)clientFuture, (FutureCallback)new FutureCallback<FrameFilePartialFetch>(){

            public void onSuccess(FrameFilePartialFetch partialFetch) {
                if (partialFetch.isExceptionCaught()) {
                    if (partialFetch.getExceptionCaught() instanceof ChannelClosedForWritesException) {
                        retVal.setException(partialFetch.getExceptionCaught());
                        return;
                    }
                    log.noStackTrace().warn(partialFetch.getExceptionCaught(), "Attempting recovery after exception while reading channel[%s]", new Object[]{channel.getId()});
                }
                partialFetch.backpressureFuture().addListener(() -> retVal.set((Object)partialFetch.isLastFetch()), (Executor)Execs.directExecutor());
            }

            public void onFailure(Throwable t) {
                retVal.setException(t);
            }
        }, (Executor)Execs.directExecutor());
        return retVal;
    }

    protected abstract ServiceClient getClient(String var1);

    protected <T> T deserialize(BytesFullResponseHolder bytesHolder, TypeReference<T> typeReference) {
        try {
            return (T)this.objectMapper.readValue(bytesHolder.getContent(), typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

