/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.google.inject.Inject;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.msq.exec.QueryKitSpecFactory;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;

public class DartQueryKitSpecFactory
implements QueryKitSpecFactory {
    private final TimelineServerView serverView;

    @Inject
    public DartQueryKitSpecFactory(TimelineServerView serverView) {
        this.serverView = serverView;
    }

    @Override
    public QueryKitSpec makeQueryKitSpec(QueryKit<Query<?>> queryKit, String queryId, MSQTuningConfig tuningConfig, QueryContext queryContext) {
        return new QueryKitSpec(queryKit, queryId, this.getNumWorkers(), queryContext.getInt("maxNonLeafWorkers", 1), MultiStageQueryContext.getTargetPartitionsPerWorkerWithDefault(queryContext, 1));
    }

    private int getNumWorkers() {
        int cnt = 0;
        for (DruidServerMetadata s : this.serverView.getDruidServerMetadatas()) {
            if (s.getType() != ServerType.HISTORICAL) continue;
            ++cnt;
        }
        return Math.max(1, cnt);
    }
}

