/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.druid.frame.key.ClusterByPartition;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.statistics.KeyCollector;

public class DistinctKeyCollector
implements KeyCollector<DistinctKeyCollector> {
    static final int INITIAL_MAX_BYTES = 0x8000000;
    static final int SMALLEST_MAX_BYTES = 5000;
    private static final int MISSING_KEY_WEIGHT = 0;
    private final Comparator<RowKey> comparator;
    private final Object2LongSortedMap<RowKey> retainedKeys;
    private int maxBytes;
    private int retainedBytes;
    private int spaceReductionFactor;
    private long totalWeightUnadjusted;

    DistinctKeyCollector(Comparator<RowKey> comparator, Object2LongSortedMap<RowKey> retainedKeys, int spaceReductionFactor) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator, (Object)"comparator");
        this.retainedKeys = (Object2LongSortedMap)Preconditions.checkNotNull(retainedKeys, (Object)"retainedKeys");
        this.retainedKeys.defaultReturnValue(0L);
        this.maxBytes = 0x8000000;
        this.spaceReductionFactor = spaceReductionFactor;
        this.totalWeightUnadjusted = 0L;
        LongIterator weightIterator = retainedKeys.values().iterator();
        while (weightIterator.hasNext()) {
            this.totalWeightUnadjusted += weightIterator.nextLong();
        }
    }

    DistinctKeyCollector(Comparator<RowKey> comparator) {
        this(comparator, (Object2LongSortedMap<RowKey>)new Object2LongRBTreeMap(comparator), 0);
    }

    @Override
    public void add(RowKey key, long weight) {
        boolean isNewMin;
        if (weight <= 0L) {
            throw new IAE("Weight must be positive", new Object[0]);
        }
        boolean bl = isNewMin = this.retainedKeys.isEmpty() || this.comparator.compare(key, (RowKey)this.retainedKeys.firstKey()) < 0;
        if (isNewMin || this.isKeySelected(key)) {
            if (isNewMin && !this.retainedKeys.isEmpty() && !this.isKeySelected((RowKey)this.retainedKeys.firstKey())) {
                RowKey rowKey = (RowKey)this.retainedKeys.firstKey();
                this.totalWeightUnadjusted -= this.retainedKeys.removeLong((Object)rowKey);
                this.retainedBytes -= rowKey.estimatedObjectSizeBytes();
            }
            if (this.retainedKeys.putIfAbsent((Object)key, weight) == 0L) {
                this.totalWeightUnadjusted += weight;
                this.retainedBytes += key.estimatedObjectSizeBytes();
            }
            while (this.retainedBytes >= this.maxBytes) {
                this.increaseSpaceReductionFactorIfPossible();
            }
        }
    }

    @Override
    public void addAll(DistinctKeyCollector other) {
        while (!this.retainedKeys.isEmpty() && this.spaceReductionFactor < other.spaceReductionFactor) {
            this.increaseSpaceReductionFactorIfPossible();
        }
        if (this.retainedKeys.isEmpty()) {
            this.spaceReductionFactor = other.spaceReductionFactor;
            this.retainedKeys.putAll(other.retainedKeys);
            this.maxBytes = other.maxBytes;
            this.totalWeightUnadjusted = other.totalWeightUnadjusted;
        } else {
            for (Object2LongMap.Entry otherEntry : other.retainedKeys.object2LongEntrySet()) {
                this.add((RowKey)otherEntry.getKey(), otherEntry.getLongValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.retainedKeys.isEmpty();
    }

    @Override
    public long estimatedTotalWeight() {
        assert (this.totalWeightUnadjusted == this.retainedKeys.values().longStream().sum());
        return this.totalWeightUnadjusted << this.spaceReductionFactor;
    }

    @Override
    public int estimatedRetainedKeys() {
        return this.retainedKeys.size();
    }

    @Override
    public long estimatedRetainedBytes() {
        return this.retainedBytes;
    }

    @Override
    public RowKey minKey() {
        return (RowKey)this.retainedKeys.firstKey();
    }

    @Override
    public boolean downSample() {
        if (this.retainedKeys.size() <= 1) {
            return true;
        }
        if (this.maxBytes <= 5000) {
            return false;
        }
        this.maxBytes /= 2;
        while (this.retainedBytes >= this.maxBytes) {
            if (this.increaseSpaceReductionFactorIfPossible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClusterByPartitions generatePartitionsWithTargetWeight(long targetPartitionWeight) {
        if (targetPartitionWeight <= 0L) {
            throw new IAE("targetPartitionWeight must be positive, but was [%d]", new Object[]{targetPartitionWeight});
        }
        if (this.retainedKeys.isEmpty()) {
            return ClusterByPartitions.oneUniversalPartition();
        }
        ArrayList<ClusterByPartition> partitions = new ArrayList<ClusterByPartition>();
        ObjectBidirectionalIterator iterator = this.retainedKeys.object2LongEntrySet().iterator();
        RowKey startKey = (RowKey)this.retainedKeys.firstKey();
        long partitionWeight = 0L;
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            long keyWeight = entry.getLongValue() << this.spaceReductionFactor;
            long partitionCountAfterKey = partitionWeight + keyWeight;
            if (partitionWeight > 0L && partitionCountAfterKey > targetPartitionWeight && partitionCountAfterKey - targetPartitionWeight > targetPartitionWeight - partitionWeight) {
                partitions.add(new ClusterByPartition(startKey, (RowKey)entry.getKey()));
                startKey = (RowKey)entry.getKey();
                partitionWeight = keyWeight;
                continue;
            }
            partitionWeight = partitionCountAfterKey;
        }
        partitions.add(new ClusterByPartition(startKey, null));
        return new ClusterByPartitions(partitions);
    }

    @Override
    public int sketchAccuracyFactor() {
        return -this.spaceReductionFactor;
    }

    @JsonProperty(value="keys")
    Map<RowKey, Long> getRetainedKeys() {
        return this.retainedKeys;
    }

    @JsonProperty(value="maxBytes")
    int getMaxBytes() {
        return this.maxBytes;
    }

    @JsonProperty(value="spaceReductionFactor")
    int getSpaceReductionFactor() {
        return this.spaceReductionFactor;
    }

    private boolean isKeySelected(RowKey key) {
        return this.spaceReductionFactor == 0 || Long.numberOfTrailingZeros(key.longHashCode()) >= this.spaceReductionFactor;
    }

    private boolean increaseSpaceReductionFactorIfPossible() {
        if (this.spaceReductionFactor == 64) {
            return false;
        }
        if (this.retainedKeys.isEmpty()) {
            throw new ISE("Cannot increase space reduction factor when keys are empty", new Object[0]);
        }
        ++this.spaceReductionFactor;
        ObjectBidirectionalIterator iterator = this.retainedKeys.object2LongEntrySet().iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            RowKey key = (RowKey)entry.getKey();
            if (this.isKeySelected(key)) continue;
            this.totalWeightUnadjusted -= entry.getLongValue();
            this.retainedBytes -= ((RowKey)entry.getKey()).estimatedObjectSizeBytes();
            iterator.remove();
        }
        return true;
    }

    public String toString() {
        return "DistinctKeyCollector{maxBytes=" + this.maxBytes + ", retainedBytes=" + this.retainedBytes + ", spaceReductionFactor=" + this.spaceReductionFactor + ", totalWeightUnadjusted=" + this.totalWeightUnadjusted + "}";
    }
}

