/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.db.cache;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.security.basic.CommonCacheNotifier;
import org.apache.druid.security.basic.authorization.BasicRoleBasedAuthorizer;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheNotifier;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;

@ManageLifecycle
public class CoordinatorBasicAuthorizerCacheNotifier
implements BasicAuthorizerCacheNotifier {
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final CommonCacheNotifier cacheUserNotifier;
    private final CommonCacheNotifier cacheGroupMappingNotifier;

    @Inject
    public CoordinatorBasicAuthorizerCacheNotifier(AuthorizerMapper authorizerMapper, DruidNodeDiscoveryProvider discoveryProvider, @EscalatedClient HttpClient httpClient) {
        this.cacheUserNotifier = new CommonCacheNotifier(this.getAuthorizerConfigMap(authorizerMapper), discoveryProvider, httpClient, "/druid-ext/basic-security/authorization/listen/users/%s", "CoordinatorBasicAuthorizerCacheNotifier");
        this.cacheGroupMappingNotifier = new CommonCacheNotifier(this.getAuthorizerConfigMap(authorizerMapper), discoveryProvider, httpClient, "/druid-ext/basic-security/authorization/listen/groupMappings/%s", "CoordinatorBasicAuthorizerCacheNotifier");
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.cacheUserNotifier.start();
            this.cacheGroupMappingNotifier.start();
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            return;
        }
        try {
            this.cacheUserNotifier.stop();
            this.cacheGroupMappingNotifier.stop();
        }
        finally {
            this.lifecycleLock.exitStop();
        }
    }

    @Override
    public void addUpdateUser(String updatedAuthorizerPrefix, byte[] userAndRoleMap) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.cacheUserNotifier.addUpdate(updatedAuthorizerPrefix, userAndRoleMap);
    }

    @Override
    public void addUpdateGroupMapping(String updatedAuthorizerPrefix, byte[] groupMappingAndRoleMap) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.cacheGroupMappingNotifier.addUpdate(updatedAuthorizerPrefix, groupMappingAndRoleMap);
    }

    private Map<String, BasicAuthDBConfig> getAuthorizerConfigMap(AuthorizerMapper mapper) {
        Preconditions.checkNotNull((Object)mapper);
        Preconditions.checkNotNull((Object)mapper.getAuthorizerMap());
        HashMap<String, BasicAuthDBConfig> authorizerConfigMap = new HashMap<String, BasicAuthDBConfig>();
        for (Map.Entry entry : mapper.getAuthorizerMap().entrySet()) {
            Authorizer authorizer = (Authorizer)entry.getValue();
            if (!(authorizer instanceof BasicRoleBasedAuthorizer)) continue;
            String authorizerName = (String)entry.getKey();
            BasicRoleBasedAuthorizer basicRoleBasedAuthorizer = (BasicRoleBasedAuthorizer)authorizer;
            BasicAuthDBConfig dbConfig = basicRoleBasedAuthorizer.getDbConfig();
            authorizerConfigMap.put(authorizerName, dbConfig);
        }
        return authorizerConfigMap;
    }
}

