/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ConnectionPoolConfiguration;
import com.amazonaws.services.rds.model.ModifyDBProxyTargetGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBProxyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyDBProxyTargetGroupRequest>, ModifyDBProxyTargetGroupRequest> {
    public Request<ModifyDBProxyTargetGroupRequest> marshall(ModifyDBProxyTargetGroupRequest modifyDBProxyTargetGroupRequest) {
        ConnectionPoolConfiguration connectionPoolConfig;
        if (modifyDBProxyTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBProxyTargetGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBProxyTargetGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBProxyTargetGroupRequest.getTargetGroupName() != null) {
            request.addParameter("TargetGroupName", StringUtils.fromString((String)modifyDBProxyTargetGroupRequest.getTargetGroupName()));
        }
        if (modifyDBProxyTargetGroupRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)modifyDBProxyTargetGroupRequest.getDBProxyName()));
        }
        if ((connectionPoolConfig = modifyDBProxyTargetGroupRequest.getConnectionPoolConfig()) != null) {
            if (connectionPoolConfig.getMaxConnectionsPercent() != null) {
                request.addParameter("ConnectionPoolConfig.MaxConnectionsPercent", StringUtils.fromInteger((Integer)connectionPoolConfig.getMaxConnectionsPercent()));
            }
            if (connectionPoolConfig.getMaxIdleConnectionsPercent() != null) {
                request.addParameter("ConnectionPoolConfig.MaxIdleConnectionsPercent", StringUtils.fromInteger((Integer)connectionPoolConfig.getMaxIdleConnectionsPercent()));
            }
            if (connectionPoolConfig.getConnectionBorrowTimeout() != null) {
                request.addParameter("ConnectionPoolConfig.ConnectionBorrowTimeout", StringUtils.fromInteger((Integer)connectionPoolConfig.getConnectionBorrowTimeout()));
            }
            if (!connectionPoolConfig.getSessionPinningFilters().isEmpty() || !((SdkInternalList)connectionPoolConfig.getSessionPinningFilters()).isAutoConstruct()) {
                SdkInternalList sessionPinningFiltersList = (SdkInternalList)connectionPoolConfig.getSessionPinningFilters();
                int sessionPinningFiltersListIndex = 1;
                for (String sessionPinningFiltersListValue : sessionPinningFiltersList) {
                    if (sessionPinningFiltersListValue != null) {
                        request.addParameter("ConnectionPoolConfig.SessionPinningFilters.member." + sessionPinningFiltersListIndex, StringUtils.fromString((String)sessionPinningFiltersListValue));
                    }
                    ++sessionPinningFiltersListIndex;
                }
            }
            if (connectionPoolConfig.getInitQuery() != null) {
                request.addParameter("ConnectionPoolConfig.InitQuery", StringUtils.fromString((String)connectionPoolConfig.getInitQuery()));
            }
        }
        if (modifyDBProxyTargetGroupRequest.getNewName() != null) {
            request.addParameter("NewName", StringUtils.fromString((String)modifyDBProxyTargetGroupRequest.getNewName()));
        }
        return request;
    }
}

