/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.NotSupportedException;

public class ColumnUtils {
    private static ColumnUtils instance = new ColumnUtils();

    public static ColumnUtils getInstance() {
        return instance;
    }

    public static void setInstance(ColumnUtils columnUtils) {
        instance = columnUtils;
    }

    public static int getMinLength(ColumnExpr columnExpr) {
        Object value = instance.getColumnAttribute(columnExpr, "minLength");
        return value instanceof Number ? ((Number)value).intValue() : 0;
    }

    public static int getMaxLength(ColumnExpr columnExpr) {
        return instance.getColumnMaxLength(columnExpr);
    }

    public static Number getMinValue(ColumnExpr columnExpr) {
        if (!columnExpr.getDataType().isNumeric()) {
            return null;
        }
        Object value = instance.getColumnAttribute(columnExpr, "minValue");
        return ObjectUtils.getDecimal(value);
    }

    public static Number getMaxValue(ColumnExpr columnExpr) {
        long maxVal;
        if (!columnExpr.getDataType().isNumeric()) {
            return null;
        }
        if (columnExpr.getDataType() == DataType.AUTOINC) {
            return Long.MAX_VALUE;
        }
        Object value = instance.getColumnAttribute(columnExpr, "maxValue");
        long digits = (long)instance.getColumnSize(columnExpr);
        long l = maxVal = digits != 0L ? 0xAL ^ digits : 6L;
        if (columnExpr.getDataType() == DataType.INTEGER) {
            return ObjectUtils.getLong(value, maxVal);
        }
        return ObjectUtils.getDecimal(value, BigDecimal.valueOf(maxVal));
    }

    public static <T extends ColumnExpr> T setMinMaxValue(T columnExpr, Number minValue, Number maxValue) {
        if (!columnExpr.getDataType().isNumeric()) {
            throw new NotSupportedException(columnExpr, "setMinMaxValue");
        }
        columnExpr.setAttribute("minValue", minValue);
        columnExpr.setAttribute("maxValue", maxValue);
        return columnExpr;
    }

    public static NumberFormat getNumberFormat(ColumnExpr columnExpr, Locale locale) {
        return instance.getColumnNumberFormat(columnExpr, locale);
    }

    public static <T extends ColumnExpr> T setNumberFormat(T columnExpr, String numberType, boolean groupSeparator) {
        if (!columnExpr.getDataType().isNumeric()) {
            throw new NotSupportedException(columnExpr, "setNumberFormat");
        }
        instance.setColumnNumberFormat(columnExpr, numberType, groupSeparator);
        return columnExpr;
    }

    public Object getColumnAttribute(ColumnExpr columnExpr, String name) {
        return columnExpr.getAttribute(name);
    }

    public double getColumnSize(ColumnExpr columnExpr) {
        Column updColumn = columnExpr.getUpdateColumn();
        return updColumn != null ? updColumn.getSize() : 0.0;
    }

    public int getColumnMaxLength(ColumnExpr columnExpr) {
        switch (columnExpr.getDataType()) {
            case INTEGER: 
            case AUTOINC: {
                int intSize = (int)this.getColumnSize(columnExpr);
                return intSize > 0 ? intSize : 12;
            }
            case CHAR: 
            case VARCHAR: {
                return (int)this.getColumnSize(columnExpr);
            }
            case DATE: 
            case TIME: {
                return 10;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return 20;
            }
            case FLOAT: 
            case DECIMAL: {
                double size = this.getColumnSize(columnExpr);
                int intDigits = Math.min((int)size, 1);
                int fracDigits = (int)(size * 10.0) - intDigits * 10;
                return fracDigits > 0 ? intDigits + fracDigits + 1 : intDigits;
            }
            case BOOL: {
                return 1;
            }
            case UNIQUEID: {
                return 36;
            }
        }
        return -1;
    }

    public NumberFormat getColumnNumberFormat(ColumnExpr columnExpr, Locale locale) {
        int integerDigits;
        Object intDigits;
        Object limitFractionDigits;
        String type = StringUtils.valueOf(this.getColumnAttribute(columnExpr, "numberType"));
        boolean isInteger = Column.NUMTYPE_INTEGER.equalsIgnoreCase(type);
        NumberFormat nf = isInteger ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getNumberInstance(locale);
        Object groupSep = this.getColumnAttribute(columnExpr, "numberGroupSeparator");
        nf.setGroupingUsed(groupSep != null && ObjectUtils.getBoolean(groupSep));
        Object object = limitFractionDigits = isInteger ? null : this.getColumnAttribute(columnExpr, "numberFractionDigits");
        if (limitFractionDigits != null) {
            int intLen;
            double size;
            int minFactionDigits = 0;
            int maxFactionDigits = -1;
            if (!(limitFractionDigits instanceof Number)) {
                String limit = limitFractionDigits.toString();
                if (limit.startsWith("min:")) {
                    minFactionDigits = ObjectUtils.getInteger(limit.substring(4), 0);
                } else if (limit.startsWith("max:")) {
                    maxFactionDigits = ObjectUtils.getInteger(limit.substring(4), -1);
                } else if ("auto".equals(limitFractionDigits)) {
                    minFactionDigits = 999;
                } else if (!"limit".equals(limitFractionDigits)) {
                    minFactionDigits = maxFactionDigits = ObjectUtils.getInteger(limit, -1);
                }
            } else {
                minFactionDigits = maxFactionDigits = ((Number)limitFractionDigits).intValue();
            }
            if (minFactionDigits < 0) {
                minFactionDigits = 0;
            }
            if (maxFactionDigits < 0 && minFactionDigits > (maxFactionDigits = (int)((size = columnExpr instanceof Column ? ((Column)columnExpr).getSize() : 0.0) * 10.0) - (intLen = (int)size) * 10)) {
                minFactionDigits = maxFactionDigits;
            }
            nf.setMinimumFractionDigits(minFactionDigits);
            nf.setMaximumFractionDigits(maxFactionDigits);
        }
        if ((intDigits = this.getColumnAttribute(columnExpr, "numberIntegerDigits")) != null && (integerDigits = ObjectUtils.getInteger(intDigits)) > 0) {
            nf.setMinimumIntegerDigits(integerDigits);
        }
        return nf;
    }

    public void setColumnNumberFormat(ColumnExpr columnExpr, String numberType, boolean groupSeparator) {
        columnExpr.setAttribute("numberType", numberType);
        columnExpr.setAttribute("numberGroupSeparator", groupSeparator);
        if (columnExpr.getDataType() == DataType.DECIMAL || columnExpr.getDataType() == DataType.FLOAT) {
            double size = this.getColumnSize(columnExpr);
            int intDigits = (int)size;
            int fracDigits = (int)(size * 10.0) - intDigits * 10;
            columnExpr.setAttribute("numberFractionDigits", fracDigits);
        } else {
            columnExpr.setAttribute("numberFractionDigits", 0);
        }
    }
}

