/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.HttpServiceServletHandler;
import org.apache.felix.http.base.internal.handler.HttpServiceWebSocketServletHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.handler.WebSocketHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.service.HttpResourceServlet;
import org.apache.felix.http.jakartawrappers.ServletWrapper;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.http.NamespaceException;

public final class SharedHttpServiceImpl {
    private final HandlerRegistry handlerRegistry;
    private final Map<String, ServletHandler> aliasMap = new HashMap<String, ServletHandler>();
    private Map<String, Object> attributesForSharedContext;

    public SharedHttpServiceImpl(HandlerRegistry handlerRegistry) {
        if (handlerRegistry == null) {
            throw new IllegalArgumentException("HandlerRegistry cannot be null!");
        }
        this.handlerRegistry = handlerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(@NotNull String alias, @NotNull ExtServletContext httpContext, @NotNull Servlet servlet, @NotNull ServletInfo servletInfo) throws ServletException, NamespaceException {
        HttpServiceServletHandler handler = SharedHttpServiceImpl.getServletHandler(httpContext, servlet, servletInfo);
        this.setAttributes(httpContext);
        Map<String, ServletHandler> map = this.aliasMap;
        synchronized (map) {
            if (this.aliasMap.containsKey(alias)) {
                throw new NamespaceException("Alias " + alias + " is already in use.");
            }
            this.handlerRegistry.getRegistry(handler.getContextServiceId()).registerServlet(handler);
            this.aliasMap.put(alias, handler);
        }
    }

    @NotNull
    private static HttpServiceServletHandler getServletHandler(@NotNull ExtServletContext httpContext, @NotNull Servlet servlet, @NotNull ServletInfo servletInfo) {
        if (WebSocketHandler.isJettyWebSocketServlet(servlet)) {
            return new HttpServiceWebSocketServletHandler(httpContext, servletInfo, servlet);
        }
        return new HttpServiceServletHandler(httpContext, servletInfo, servlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet unregister(String alias) {
        Map<String, ServletHandler> map = this.aliasMap;
        synchronized (map) {
            ServletHandler handler = this.aliasMap.remove(alias);
            if (handler == null) {
                throw new IllegalArgumentException("Nothing registered at " + alias);
            }
            Servlet s = this.getServlet(handler);
            if (handler.getServlet() instanceof HttpResourceServlet) {
                HttpResourceServlet resource = (HttpResourceServlet)handler.getServlet();
                resource.setWrapper(null);
            }
            this.handlerRegistry.getRegistry(handler.getContextServiceId()).unregisterServlet(handler.getServletInfo(), true);
            return s;
        }
    }

    private Servlet getServlet(ServletHandler handler) {
        Servlet s;
        if (handler.getServlet() instanceof HttpResourceServlet) {
            HttpResourceServlet resource = (HttpResourceServlet)handler.getServlet();
            s = resource.getWrapper();
            resource.setWrapper(null);
        } else {
            s = ((ServletWrapper)handler.getServlet()).getServlet();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServlet(Servlet servlet) {
        if (servlet != null) {
            Map<String, ServletHandler> map = this.aliasMap;
            synchronized (map) {
                Iterator<Map.Entry<String, ServletHandler>> i = this.aliasMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, ServletHandler> entry = i.next();
                    Servlet s = this.getServlet(entry.getValue());
                    if (s != servlet) continue;
                    this.handlerRegistry.getRegistry(entry.getValue().getContextServiceId()).unregisterServlet(entry.getValue().getServletInfo(), false);
                    i.remove();
                    break;
                }
            }
        }
    }

    @NotNull
    public HandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public void setSharedContextAttributes(Map<String, Object> attributesForSharedContext) {
        this.attributesForSharedContext = attributesForSharedContext;
    }

    private void setAttributes(ExtServletContext context) {
        if (context != null && this.attributesForSharedContext != null) {
            this.attributesForSharedContext.forEach((key, value) -> {
                if (key != null && value != null) {
                    SystemLogger.LOGGER.info("SharedHttpServiceImpl: Shared context found, setting stored attribute key: '{}', value: '{}'", key, value);
                    context.setAttribute((String)key, value);
                }
            });
        }
    }
}

