/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.storage.GSBlobStorage;
import org.apache.flink.fs.gs.utils.ChecksumUtils;
import org.apache.flink.shaded.guava31.com.google.common.hash.Hasher;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSChecksumWriteChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSChecksumWriteChannel.class);
    private final GSBlobStorage storage;
    private final GSBlobStorage.WriteChannel writeChannel;
    private final GSBlobIdentifier blobIdentifier;
    private final Hasher hasher;

    public GSChecksumWriteChannel(GSBlobStorage storage, GSBlobStorage.WriteChannel writeChannel, GSBlobIdentifier blobIdentifier) {
        LOGGER.trace("Creating GSChecksumWriteChannel for blob {}", (Object)blobIdentifier);
        this.storage = (GSBlobStorage)Preconditions.checkNotNull((Object)storage);
        this.writeChannel = (GSBlobStorage.WriteChannel)Preconditions.checkNotNull((Object)writeChannel);
        this.blobIdentifier = (GSBlobIdentifier)Preconditions.checkNotNull((Object)blobIdentifier);
        this.hasher = ChecksumUtils.CRC_HASH_FUNCTION.newHasher();
    }

    public int write(byte[] content, int start, int length) throws IOException {
        LOGGER.trace("Writing {} bytes to blob {}", (Object)length, (Object)this.blobIdentifier);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        this.hasher.putBytes(content, start, length);
        return this.writeChannel.write(content, start, length);
    }

    public void close() throws IOException {
        String blobChecksum;
        LOGGER.trace("Closing write channel to blob {}", (Object)this.blobIdentifier);
        this.writeChannel.close();
        Optional<GSBlobStorage.BlobMetadata> blobMetadata = this.storage.getMetadata(this.blobIdentifier);
        if (!blobMetadata.isPresent()) {
            throw new IOException(String.format("Failed to read metadata for blob %s", this.blobIdentifier));
        }
        String writeChecksum = ChecksumUtils.convertChecksumToString(this.hasher.hash().asInt());
        if (!writeChecksum.equals(blobChecksum = blobMetadata.get().getChecksum())) {
            throw new IOException(String.format("Checksum mismatch writing blob %s: expected %s but found %s", this.blobIdentifier, writeChecksum, blobChecksum));
        }
    }
}

