/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.impl.ParseException;

public class SqlShowDatabases
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW DATABASES", SqlKind.OTHER);
    private final String preposition;
    private final SqlIdentifier catalogName;
    private final String likeType;
    private final SqlCharStringLiteral likeLiteral;
    private final boolean notLike;

    public String[] getCatalog() {
        return this.catalogName == null || this.catalogName.names.isEmpty() ? new String[]{} : this.catalogName.names.toArray(new String[0]);
    }

    public SqlShowDatabases(SqlParserPos pos, String preposition, SqlIdentifier catalogName, String likeType, SqlCharStringLiteral likeLiteral, boolean notLike) throws ParseException {
        super(pos);
        this.preposition = preposition;
        SqlIdentifier sqlIdentifier = this.catalogName = preposition != null ? Objects.requireNonNull(catalogName, "Catalog name must not be null.") : null;
        if (this.catalogName != null && this.catalogName.names.size() > 1) {
            throw new ParseException(String.format("Show databases from/in identifier [ %s ] format error, catalog must be a single part identifier.", String.join((CharSequence)".", this.catalogName.names)));
        }
        if (likeType != null) {
            this.likeType = likeType;
            this.likeLiteral = Objects.requireNonNull(likeLiteral, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.likeLiteral = null;
            this.notLike = false;
        }
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return this.catalogName == null ? Collections.emptyList() : Collections.singletonList(this.catalogName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SHOW DATABASES");
        if (this.preposition != null) {
            writer.keyword(this.preposition);
            this.catalogName.unparse(writer, leftPrec, rightPrec);
        }
        if (this.likeType != null) {
            writer.keyword(this.isNotLike() ? String.format("NOT %s '%s'", this.likeType, this.getLikeSqlPattern()) : String.format("%s '%s'", this.likeType, this.getLikeSqlPattern()));
        }
    }

    public String getLikeSqlPattern() {
        return this.likeLiteral == null ? null : this.likeLiteral.getValueAs(String.class);
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public String getPreposition() {
        return this.preposition;
    }

    public String getLikeType() {
        return this.likeType;
    }
}

