/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.async;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.connector.datagen.source.DataGeneratorSource;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.apache.flink.streaming.examples.async.AsyncClient;

public class AsyncIOExample {
    public static void main(String[] args) throws Exception {
        SingleOutputStreamOperator result;
        long timeout;
        String mode;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        try {
            mode = params.get("waitMode", "ordered");
            timeout = params.getLong("timeout", 10000L);
        }
        catch (Exception e) {
            System.out.println("To customize example, use: AsyncIOExample [--waitMode <ordered or unordered>]");
            throw e;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataGeneratorSource generatorSource = new DataGeneratorSource(Long::intValue, Integer.MAX_VALUE, RateLimiterStrategy.perSecond((double)100.0), Types.INT);
        DataStreamSource inputStream = env.fromSource(generatorSource, WatermarkStrategy.noWatermarks(), "Integers-generating Source");
        SampleAsyncFunction function = new SampleAsyncFunction();
        switch (mode.toUpperCase()) {
            case "ORDERED": {
                result = AsyncDataStream.orderedWait((DataStream)inputStream, (AsyncFunction)function, (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS, (int)20);
                break;
            }
            case "UNORDERED": {
                result = AsyncDataStream.unorderedWait((DataStream)inputStream, (AsyncFunction)function, (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS, (int)20);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode: " + mode);
            }
        }
        result.print();
        env.execute("Async IO Example: " + mode);
    }

    private static class SampleAsyncFunction
    extends RichAsyncFunction<Integer, String> {
        private static final long serialVersionUID = 1L;
        private transient AsyncClient client;

        private SampleAsyncFunction() {
        }

        public void open(OpenContext openContext) {
            this.client = new AsyncClient();
        }

        public void asyncInvoke(Integer input, ResultFuture<String> resultFuture) {
            this.client.query(input).whenComplete((response, error) -> {
                if (response != null) {
                    resultFuture.complete(Collections.singletonList(response));
                } else {
                    resultFuture.completeExceptionally(error);
                }
            });
        }
    }
}

