/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;

@PublicEvolving
public class CatalogDescriptor {
    private final String catalogName;
    private final Configuration configuration;
    @Nullable
    private final String comment;

    public String getCatalogName() {
        return this.catalogName;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public CatalogDescriptor setComment(@Nonnull String comment) {
        return new CatalogDescriptor(this.catalogName, this.configuration, comment);
    }

    private CatalogDescriptor(String catalogName, Configuration configuration, @Nullable String comment) {
        this.catalogName = catalogName;
        this.configuration = configuration;
        this.comment = comment;
    }

    public static CatalogDescriptor of(String catalogName, Configuration configuration, String comment) {
        return new CatalogDescriptor(catalogName, configuration, comment);
    }

    public static CatalogDescriptor of(String catalogName, Configuration configuration) {
        return new CatalogDescriptor(catalogName, configuration, null);
    }
}

