/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import javax.annotation.Nullable;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

public final class LocalMetadataEntry {
    @Nullable
    private PathMetadata pathMetadata;
    @Nullable
    private DirListingMetadata dirListingMetadata;

    LocalMetadataEntry() {
    }

    LocalMetadataEntry(PathMetadata pmd) {
        this.pathMetadata = pmd;
        this.dirListingMetadata = null;
    }

    LocalMetadataEntry(DirListingMetadata dlm) {
        this.pathMetadata = null;
        this.dirListingMetadata = dlm;
    }

    public PathMetadata getFileMeta() {
        return this.pathMetadata;
    }

    public DirListingMetadata getDirListingMeta() {
        return this.dirListingMetadata;
    }

    public boolean hasPathMeta() {
        return this.pathMetadata != null;
    }

    public boolean hasDirMeta() {
        return this.dirListingMetadata != null;
    }

    public void setPathMetadata(PathMetadata pathMetadata) {
        this.pathMetadata = pathMetadata;
    }

    public void setDirListingMetadata(DirListingMetadata dirListingMetadata) {
        this.dirListingMetadata = dirListingMetadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalMetadataEntry{");
        if (this.pathMetadata != null) {
            sb.append("pathMetadata=" + this.pathMetadata.getFileStatus().getPath());
        }
        if (this.dirListingMetadata != null) {
            sb.append("; dirListingMetadata=" + this.dirListingMetadata.getPath());
        }
        sb.append("}");
        return sb.toString();
    }
}

