/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

public abstract class AbstractS3AStatisticsSource
implements IOStatisticsSource,
DurationTrackerFactory {
    private IOStatisticsStore ioStatistics;

    protected AbstractS3AStatisticsSource() {
    }

    @Override
    public IOStatisticsStore getIOStatistics() {
        return this.ioStatistics;
    }

    protected void setIOStatistics(IOStatisticsStore statistics) {
        this.ioStatistics = statistics;
    }

    public long incCounter(String name) {
        return this.incCounter(name, 1L);
    }

    public long incCounter(String name, long value) {
        return this.ioStatistics.incrementCounter(name, value);
    }

    public Long lookupCounterValue(String name) {
        return this.ioStatistics.counters().get(name);
    }

    public Long lookupGaugeValue(String name) {
        return this.ioStatistics.gauges().get(name);
    }

    public long incGauge(String name, long v) {
        return this.ioStatistics.incrementGauge(name, v);
    }

    public long incGauge(String name) {
        return this.incGauge(name, 1L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractS3AStatisticsSource{");
        sb.append(this.ioStatistics);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public DurationTracker trackDuration(String key, long count) {
        return this.getIOStatistics().trackDuration(key, count);
    }
}

