/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.common.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.ByteBufferReadable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.util.Preconditions;

public final class HadoopDataInputStream
extends FSDataInputStream
implements ByteBufferReadable {
    public static final int MIN_SKIP_BYTES = 0x100000;
    private final org.apache.hadoop.fs.FSDataInputStream fsDataInputStream;

    public HadoopDataInputStream(org.apache.hadoop.fs.FSDataInputStream fsDataInputStream) {
        this.fsDataInputStream = (org.apache.hadoop.fs.FSDataInputStream)Preconditions.checkNotNull((Object)fsDataInputStream);
    }

    public void seek(long seekPos) throws IOException {
        long delta = seekPos - this.getPos();
        if (delta > 0L && delta <= 0x100000L) {
            this.skipFully(delta);
        } else if (delta != 0L) {
            this.forceSeek(seekPos);
        }
    }

    public long getPos() throws IOException {
        return this.fsDataInputStream.getPos();
    }

    public int read() throws IOException {
        return this.fsDataInputStream.read();
    }

    public void close() throws IOException {
        this.fsDataInputStream.close();
    }

    public int read(@Nonnull byte[] buffer, int offset, int length) throws IOException {
        return this.fsDataInputStream.read(buffer, offset, length);
    }

    public int available() throws IOException {
        return this.fsDataInputStream.available();
    }

    public long skip(long n) throws IOException {
        return this.fsDataInputStream.skip(n);
    }

    public org.apache.hadoop.fs.FSDataInputStream getHadoopInputStream() {
        return this.fsDataInputStream;
    }

    public void forceSeek(long seekPos) throws IOException {
        this.fsDataInputStream.seek(seekPos);
    }

    public void skipFully(long bytes) throws IOException {
        while (bytes > 0L) {
            bytes -= this.fsDataInputStream.skip(bytes);
        }
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (byteBuffer.hasArray()) {
            int len = byteBuffer.remaining();
            this.fsDataInputStream.readFully(byteBuffer.array(), byteBuffer.arrayOffset(), len);
            return len;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        byteBuffer.put((byte)c);
        int len = byteBuffer.remaining() + 1;
        for (n = 1; n < len && (c = this.read()) != -1; ++n) {
            byteBuffer.put((byte)c);
        }
        return n;
    }

    public int read(long position, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasArray()) {
            int len = byteBuffer.remaining();
            this.fsDataInputStream.readFully(position, byteBuffer.array(), byteBuffer.arrayOffset(), len);
            return len;
        }
        byte[] tmp = new byte[byteBuffer.remaining()];
        this.fsDataInputStream.readFully(position, tmp, 0, tmp.length);
        byteBuffer.put(tmp);
        return tmp.length;
    }
}

