/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomTokenProviderAdapter
extends AccessTokenProvider
implements BoundDTExtension {
    private final int fetchTokenRetryCount;
    private CustomTokenProviderAdaptee adaptee;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public CustomTokenProviderAdapter(CustomTokenProviderAdaptee adaptee, int customTokenFetchRetryCount) {
        Preconditions.checkNotNull(adaptee, "adaptee");
        this.adaptee = adaptee;
        this.fetchTokenRetryCount = customTokenFetchRetryCount;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        Exception ex;
        LOG.debug("AADToken: refreshing custom based token");
        AzureADToken azureADToken = new AzureADToken();
        String accessToken = null;
        boolean succeeded = false;
        int retryCount = this.fetchTokenRetryCount;
        do {
            ex = null;
            try {
                accessToken = this.adaptee.getAccessToken();
                LOG.trace("CustomTokenProvider Access token fetch was successful with retry count {}", (Object)(this.fetchTokenRetryCount - retryCount));
            }
            catch (Exception e) {
                LOG.debug("CustomTokenProvider Access token fetch failed with retry count {}", (Object)(this.fetchTokenRetryCount - retryCount));
                ex = e;
            }
        } while (!(succeeded = ex == null) && --retryCount >= 0);
        if (!succeeded) {
            AzureADAuthenticator.HttpException httpEx = new AzureADAuthenticator.HttpException(-1, "", String.format("CustomTokenProvider getAccessToken threw %s : %s", ex.getClass().getTypeName(), ex.getMessage()), "", "", "");
            throw httpEx;
        }
        azureADToken.setAccessToken(accessToken);
        azureADToken.setExpiry(this.adaptee.getExpiryTime());
        return azureADToken;
    }

    @Override
    public void bind(URI fsURI, Configuration conf) throws IOException {
        ExtensionHelper.bind(this.adaptee, fsURI, conf);
    }

    @Override
    public void close() {
        ExtensionHelper.close(this.adaptee);
    }

    @Override
    public String getUserAgentSuffix() {
        String suffix = ExtensionHelper.getUserAgentSuffix(this.adaptee, "");
        return suffix != null ? suffix : "";
    }
}

