/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public final class ChangelogSocketExample {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        String hostname = params.get("hostname", "localhost");
        String port = params.get("port", "9999");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        tEnv.executeSql("CREATE TABLE UserScores (name STRING, score INT)\nWITH (\n  'connector' = 'socket',\n  'hostname' = '" + hostname + "',\n  'port' = '" + port + "',\n  'byte-delimiter' = '10',\n  'format' = 'changelog-csv',\n  'changelog-csv.column-delimiter' = '|'\n)");
        Table result = tEnv.sqlQuery("SELECT name, SUM(score) FROM UserScores GROUP BY name");
        tEnv.toChangelogStream(result).print();
        env.execute();
    }
}

