/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableConfigValidation;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TableConfig
implements WritableConfig,
ReadableConfig {
    private PlannerConfig plannerConfig = PlannerConfig.EMPTY_CONFIG;
    private final Configuration configuration = new Configuration();
    private ReadableConfig rootConfiguration = new Configuration();

    private TableConfig() {
    }

    public <T> TableConfig set(ConfigOption<T> option, T value) {
        this.configuration.set(option, value);
        return this;
    }

    public TableConfig set(String key, String value) {
        this.configuration.setString(key, value);
        return this;
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.configuration.getOptional(option).orElseGet(() -> this.rootConfiguration.get(option));
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional tableValue = this.configuration.getOptional(option);
        if (tableValue.isPresent()) {
            return tableValue;
        }
        return this.rootConfiguration.getOptional(option);
    }

    @Internal
    public Map<String, String> toMap() {
        Map rootConfigMap = this.rootConfiguration.toMap();
        Map configMap = this.configuration.toMap();
        rootConfigMap.putAll(configMap);
        return rootConfigMap;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Internal
    public ReadableConfig getRootConfiguration() {
        return this.rootConfiguration;
    }

    public void addConfiguration(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration.addAll(configuration);
    }

    public SqlDialect getSqlDialect() {
        return SqlDialect.valueOf(this.get(TableConfigOptions.TABLE_SQL_DIALECT).toUpperCase());
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.set((ConfigOption)TableConfigOptions.TABLE_SQL_DIALECT, (Object)sqlDialect.name().toLowerCase());
    }

    public ZoneId getLocalTimeZone() {
        String zone = (String)this.configuration.get(TableConfigOptions.LOCAL_TIME_ZONE);
        if (((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone)) {
            return ZoneId.systemDefault();
        }
        TableConfigValidation.validateTimeZone(zone);
        return ZoneId.of(zone);
    }

    public void setLocalTimeZone(ZoneId zoneId) {
        String zone = zoneId instanceof ZoneOffset ? ZoneId.ofOffset("GMT", (ZoneOffset)zoneId).toString() : zoneId.toString();
        TableConfigValidation.validateTimeZone(zone);
        this.configuration.set(TableConfigOptions.LOCAL_TIME_ZONE, (Object)zone);
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public void setPlannerConfig(PlannerConfig plannerConfig) {
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig);
    }

    public Integer getMaxGeneratedCodeLength() {
        return (Integer)this.configuration.get(TableConfigOptions.MAX_LENGTH_GENERATED_CODE);
    }

    public void setMaxGeneratedCodeLength(Integer maxGeneratedCodeLength) {
        this.configuration.set(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, (Object)maxGeneratedCodeLength);
    }

    public void setIdleStateRetention(Duration duration) {
        this.configuration.set(ExecutionConfigOptions.IDLE_STATE_RETENTION, (Object)duration);
    }

    public Duration getIdleStateRetention() {
        return (Duration)this.configuration.get(ExecutionConfigOptions.IDLE_STATE_RETENTION);
    }

    public void addJobParameter(String key, String value) {
        Map params = this.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(HashMap::new).orElseGet(HashMap::new);
        params.put(key, value);
        this.set(PipelineOptions.GLOBAL_JOB_PARAMETERS, params);
    }

    @Internal
    public void setRootConfiguration(ReadableConfig rootConfiguration) {
        this.rootConfiguration = rootConfiguration;
    }

    public static TableConfig getDefault() {
        return new TableConfig();
    }
}

