/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kms.model.KeyEncryptionMechanism;
import com.amazonaws.services.kms.model.transform.RecipientInfoMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RecipientInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String keyEncryptionAlgorithm;
    private ByteBuffer attestationDocument;

    public void setKeyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public String getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public RecipientInfo withKeyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithm);
        return this;
    }

    public RecipientInfo withKeyEncryptionAlgorithm(KeyEncryptionMechanism keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm.toString();
        return this;
    }

    public void setAttestationDocument(ByteBuffer attestationDocument) {
        this.attestationDocument = attestationDocument;
    }

    public ByteBuffer getAttestationDocument() {
        return this.attestationDocument;
    }

    public RecipientInfo withAttestationDocument(ByteBuffer attestationDocument) {
        this.setAttestationDocument(attestationDocument);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyEncryptionAlgorithm() != null) {
            sb.append("KeyEncryptionAlgorithm: ").append(this.getKeyEncryptionAlgorithm()).append(",");
        }
        if (this.getAttestationDocument() != null) {
            sb.append("AttestationDocument: ").append(this.getAttestationDocument());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientInfo)) {
            return false;
        }
        RecipientInfo other = (RecipientInfo)obj;
        if (other.getKeyEncryptionAlgorithm() == null ^ this.getKeyEncryptionAlgorithm() == null) {
            return false;
        }
        if (other.getKeyEncryptionAlgorithm() != null && !other.getKeyEncryptionAlgorithm().equals(this.getKeyEncryptionAlgorithm())) {
            return false;
        }
        if (other.getAttestationDocument() == null ^ this.getAttestationDocument() == null) {
            return false;
        }
        return other.getAttestationDocument() == null || other.getAttestationDocument().equals(this.getAttestationDocument());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyEncryptionAlgorithm() == null ? 0 : this.getKeyEncryptionAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getAttestationDocument() == null ? 0 : this.getAttestationDocument().hashCode());
        return hashCode;
    }

    public RecipientInfo clone() {
        try {
            return (RecipientInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecipientInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

