/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input.operator;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.state.api.functions.KeyedStateReaderFunction;
import org.apache.flink.state.api.input.MultiStateKeyIterator;
import org.apache.flink.state.api.input.operator.StateReaderOperator;
import org.apache.flink.state.api.runtime.SavepointRuntimeContext;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Collector;

@Internal
public class KeyedStateReaderOperator<KEY, OUT>
extends StateReaderOperator<KeyedStateReaderFunction<KEY, OUT>, KEY, VoidNamespace, OUT> {
    private static final String USER_TIMERS_NAME = "user-timers";
    private transient Context<KEY> context;

    public KeyedStateReaderOperator(KeyedStateReaderFunction<KEY, OUT> function, TypeInformation<KEY> keyType) {
        super(function, keyType, VoidNamespaceSerializer.INSTANCE);
    }

    @Override
    public void open() throws Exception {
        super.open();
        InternalTimerService timerService = this.getInternalTimerService(USER_TIMERS_NAME);
        this.context = new Context(this.getKeyedStateBackend(), timerService);
    }

    @Override
    public void processElement(KEY key, VoidNamespace namespace, Collector<OUT> out) throws Exception {
        ((KeyedStateReaderFunction)this.function).readKey(key, this.context, out);
    }

    @Override
    public CloseableIterator<Tuple2<KEY, VoidNamespace>> getKeysAndNamespaces(SavepointRuntimeContext ctx) throws Exception {
        ctx.disableStateRegistration();
        List<StateDescriptor<?, ?>> stateDescriptors = ctx.getStateDescriptors();
        MultiStateKeyIterator keys = new MultiStateKeyIterator(stateDescriptors, this.getKeyedStateBackend());
        return new NamespaceDecorator(keys);
    }

    private static class NamespaceDecorator<KEY>
    implements CloseableIterator<Tuple2<KEY, VoidNamespace>> {
        private final CloseableIterator<KEY> keys;

        private NamespaceDecorator(CloseableIterator<KEY> keys) {
            this.keys = keys;
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Tuple2<KEY, VoidNamespace> next() {
            Object key = this.keys.next();
            return Tuple2.of((Object)key, (Object)VoidNamespace.INSTANCE);
        }

        public void remove() {
            this.keys.remove();
        }

        public void close() throws Exception {
            this.keys.close();
        }
    }

    private static class Context<K>
    implements KeyedStateReaderFunction.Context {
        private static final String EVENT_TIMER_STATE = "event-time-timers";
        private static final String PROC_TIMER_STATE = "proc-time-timers";
        ListState<Long> eventTimers;
        ListState<Long> procTimers;

        private Context(KeyedStateBackend<K> keyedStateBackend, InternalTimerService<VoidNamespace> timerService) throws Exception {
            this.eventTimers = (ListState)keyedStateBackend.getPartitionedState((Object)KeyedStateReaderOperator.USER_TIMERS_NAME, (TypeSerializer)StringSerializer.INSTANCE, (StateDescriptor)new ListStateDescriptor(EVENT_TIMER_STATE, Types.LONG));
            timerService.forEachEventTimeTimer((namespace, timer) -> {
                if (namespace.equals((Object)VoidNamespace.INSTANCE)) {
                    this.eventTimers.add(timer);
                }
            });
            this.procTimers = (ListState)keyedStateBackend.getPartitionedState((Object)KeyedStateReaderOperator.USER_TIMERS_NAME, (TypeSerializer)StringSerializer.INSTANCE, (StateDescriptor)new ListStateDescriptor(PROC_TIMER_STATE, Types.LONG));
            timerService.forEachProcessingTimeTimer((namespace, timer) -> {
                if (namespace.equals((Object)VoidNamespace.INSTANCE)) {
                    this.procTimers.add(timer);
                }
            });
        }

        @Override
        public Set<Long> registeredEventTimeTimers() throws Exception {
            Iterable timers = (Iterable)this.eventTimers.get();
            if (timers == null) {
                return Collections.emptySet();
            }
            return StreamSupport.stream(timers.spliterator(), false).collect(Collectors.toSet());
        }

        @Override
        public Set<Long> registeredProcessingTimeTimers() throws Exception {
            Iterable timers = (Iterable)this.procTimers.get();
            if (timers == null) {
                return Collections.emptySet();
            }
            return StreamSupport.stream(timers.spliterator(), false).collect(Collectors.toSet());
        }
    }
}

