/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input.operator.window;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.state.api.functions.WindowReaderFunction;
import org.apache.flink.state.api.input.operator.window.EvictingWindowReaderFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class ReduceEvictingWindowReaderFunction<IN, OUT, KEY, W extends Window>
extends EvictingWindowReaderFunction<IN, IN, OUT, KEY, W> {
    private final ReduceFunction<IN> reduceFunction;

    public ReduceEvictingWindowReaderFunction(WindowReaderFunction<IN, OUT, KEY, W> wrappedFunction, ReduceFunction<IN> reduceFunction) {
        super(wrappedFunction);
        this.reduceFunction = reduceFunction;
    }

    @Override
    public Iterable<IN> transform(Iterable<StreamRecord<IN>> elements) throws Exception {
        Object curr = null;
        for (StreamRecord<IN> element : elements) {
            if (curr == null) {
                curr = element.getValue();
                continue;
            }
            curr = this.reduceFunction.reduce(curr, element.getValue());
        }
        return Collections.singletonList(curr);
    }
}

