/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.result;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.results.ResultSet;

public class NotReadyResult
implements ResultSet {
    public static final NotReadyResult INSTANCE = new NotReadyResult();

    private NotReadyResult() {
    }

    @Override
    public ResultSet.ResultType getResultType() {
        return ResultSet.ResultType.NOT_READY;
    }

    @Override
    public Long getNextToken() {
        return 0L;
    }

    @Override
    public ResolvedSchema getResultSchema() {
        throw new UnsupportedOperationException("Don't know the schema for the result. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }

    @Override
    public List<RowData> getData() {
        return Collections.emptyList();
    }

    @Override
    public boolean isQueryResult() {
        throw new UnsupportedOperationException("Don't know whether a NOT_READY_RESULT is for a query. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }

    @Override
    public JobID getJobID() {
        throw new UnsupportedOperationException("Can't get job ID from a NOT_READY_RESULT. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }

    @Override
    public ResultKind getResultKind() {
        throw new UnsupportedOperationException("Can't get result kind from a NOT_READY_RESULT. Please continue fetching results until the result type is PAYLOAD or EOS.");
    }
}

