/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.security;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenUtils {
    public static final Logger LOG = LoggerFactory.getLogger(TokenUtils.class);
    public static final String URL_STRING = "urlString";

    private TokenUtils() {
    }

    public static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> inputMap) throws IOException {
        Map m3 = (Map)inputMap.get(Token.class.getSimpleName());
        return TokenUtils.toToken(m3);
    }

    public static Token<? extends TokenIdentifier> toToken(Map<?, ?> m3) throws IOException {
        if (m3 == null) {
            return null;
        }
        String urlString = (String)m3.get(URL_STRING);
        if (urlString != null) {
            Token token = new Token();
            LOG.debug("Read url string param - {}", (Object)urlString);
            token.decodeFromUrlString(urlString);
            return token;
        }
        return null;
    }
}

