/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.connector.base.source.hybrid.HybridSourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class HybridSourceSplitSerializer
implements SimpleVersionedSerializer<HybridSourceSplit> {
    public int getVersion() {
        return 0;
    }

    public byte[] serialize(HybridSourceSplit split) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeInt(split.sourceIndex());
                out.writeUTF(split.splitId());
                out.writeInt(split.wrappedSplitSerializerVersion());
                out.writeInt(split.wrappedSplitBytes().length);
                out.write(split.wrappedSplitBytes());
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public HybridSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        if (version == 0) {
            return this.deserializeV0(serialized);
        }
        throw new IOException(String.format("Invalid version %d", version));
    }

    private HybridSourceSplit deserializeV0(byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            HybridSourceSplit hybridSourceSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                int sourceIndex = in.readInt();
                String splitId = in.readUTF();
                int nestedVersion = in.readInt();
                int length = in.readInt();
                byte[] splitBytes = new byte[length];
                in.readFully(splitBytes);
                hybridSourceSplit = new HybridSourceSplit(sourceIndex, splitBytes, nestedVersion, splitId);
            }
            return hybridSourceSplit;
        }
    }
}

