/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

class SwitchedSources {
    private final SortedMap<Integer, Source> sources = new TreeMap<Integer, Source>();
    private final Map<Integer, SimpleVersionedSerializer<SourceSplit>> cachedSerializers = new HashMap<Integer, SimpleVersionedSerializer<SourceSplit>>();

    SwitchedSources() {
    }

    public Source sourceOf(int sourceIndex) {
        return (Source)Preconditions.checkNotNull((Object)((Source)this.sources.get(sourceIndex)), (String)"Source for index=%s not available", (Object[])new Object[]{sourceIndex});
    }

    public SimpleVersionedSerializer<SourceSplit> serializerOf(int sourceIndex) {
        return this.cachedSerializers.computeIfAbsent(sourceIndex, k -> this.sourceOf((int)k).getSplitSerializer());
    }

    public void put(int sourceIndex, Source source) {
        this.sources.put(sourceIndex, (Source)Preconditions.checkNotNull((Object)source));
    }

    public int getFirstSourceIndex() {
        return this.sources.firstKey();
    }
}

