/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.basics;

import java.io.File;
import java.io.IOException;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.util.FileUtils;

public class StreamWindowSQLExample {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        String contents = "1,beer,3,2019-12-12 00:00:01\n1,diaper,4,2019-12-12 00:00:02\n2,pen,3,2019-12-12 00:00:04\n2,rubber,3,2019-12-12 00:00:06\n3,rubber,2,2019-12-12 00:00:05\n4,beer,1,2019-12-12 00:00:08";
        String path = StreamWindowSQLExample.createTempFile(contents);
        String ddl = "CREATE TABLE orders (\n  user_id INT,\n  product STRING,\n  amount INT,\n  ts TIMESTAMP(3),\n  WATERMARK FOR ts AS ts - INTERVAL '3' SECOND\n) WITH (\n  'connector.type' = 'filesystem',\n  'connector.path' = '" + path + "',\n  'format.type' = 'csv'\n)";
        tEnv.executeSql(ddl);
        String query = "SELECT\n  CAST(TUMBLE_START(ts, INTERVAL '5' SECOND) AS STRING) window_start,\n  COUNT(*) order_num,\n  SUM(amount) total_amount,\n  COUNT(DISTINCT product) unique_products\nFROM orders\nGROUP BY TUMBLE(ts, INTERVAL '5' SECOND)";
        tEnv.executeSql(query).print();
    }

    private static String createTempFile(String contents) throws IOException {
        File tempFile = File.createTempFile("orders", ".csv");
        tempFile.deleteOnExit();
        FileUtils.writeFileUtf8((File)tempFile, (String)contents);
        return tempFile.toURI().toString();
    }
}

