/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStorageStatistics;
import javax.annotation.Nonnull;

class GhfsStreamStats {
    private final GhfsStorageStatistics storageStatistics;
    private final GhfsStatistic durationStat;
    private final Object context;
    private long maxLatencyNs;
    private int operationCount;
    private long minLatencyNs;
    private long totalNs;

    GhfsStreamStats(@Nonnull GhfsStorageStatistics storageStatistics, GhfsStatistic durationStat, Object context) {
        this.storageStatistics = storageStatistics;
        this.durationStat = durationStat;
        this.context = context;
    }

    void close() {
        if (this.operationCount == 0) {
            return;
        }
        this.storageStatistics.updateStats(this.durationStat, GhfsStreamStats.toMillis(this.minLatencyNs), GhfsStreamStats.toMillis(this.maxLatencyNs), GhfsStreamStats.toMillis(this.totalNs), this.operationCount, this.context);
        this.totalNs = 0L;
        this.operationCount = 0;
    }

    void updateWriteStreamStats(int len, long start) {
        this.updateStats(start);
        this.storageStatistics.streamWriteBytes(len);
    }

    void updateReadStreamSeekStats(long start) {
        this.updateStats(start);
    }

    void updateReadStreamStats(int len, long start) {
        this.updateStats(start);
        this.storageStatistics.streamReadBytes(len);
    }

    private static long toMillis(long nano) {
        return nano / 1000000L;
    }

    private void updateStats(long start) {
        long latency = System.nanoTime() - start;
        this.maxLatencyNs = Math.max(latency, this.maxLatencyNs);
        this.minLatencyNs = this.operationCount == 0 ? latency : Math.min(latency, this.minLatencyNs);
        this.totalNs += latency;
        ++this.operationCount;
    }
}

