/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.HadoopConfigurationProperty;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class GoogleHadoopFileSystemConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String GCS_CONFIG_PREFIX = "fs.gs";
    public static final List<String> CONFIG_KEY_PREFIXES = ImmutableList.copyOf(HadoopCredentialConfiguration.getConfigKeyPrefixes("fs.gs"));
    public static final HadoopConfigurationProperty<String> GCS_ROOT_URL = new HadoopConfigurationProperty<String>("fs.gs.storage.root.url", "https://storage.googleapis.com/", new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_SERVICE_PATH = new HadoopConfigurationProperty<String>("fs.gs.storage.service.path", "storage/v1/", new String[0]);
    public static final HadoopConfigurationProperty<String> PERMISSIONS_TO_REPORT = new HadoopConfigurationProperty<String>("fs.gs.reported.permissions", "700", new String[0]);
    public static final HadoopConfigurationProperty<Long> BLOCK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.block.size", 0x4000000L, new String[0]);
    public static final HadoopConfigurationProperty<String> DELEGATION_TOKEN_BINDING_CLASS = new HadoopConfigurationProperty("fs.gs.delegation.token.binding");
    public static final HadoopConfigurationProperty<String> GCS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.project.id");
    public static final HadoopConfigurationProperty<String> GCS_WORKING_DIRECTORY = new HadoopConfigurationProperty<String>("fs.gs.working.dir", "/", new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCE_BUCKET_DELETE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.bucket.delete.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode> GCS_REQUESTER_PAYS_MODE = new HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode>("fs.gs.requester.pays.mode", RequesterPaysOptions.REQUESTER_PAYS_MODE_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_REQUESTER_PAYS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.requester.pays.project.id");
    public static final HadoopConfigurationProperty<Collection<String>> GCS_REQUESTER_PAYS_BUCKETS = new HadoopConfigurationProperty("fs.gs.requester.pays.buckets", ImmutableList.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType> GCS_FILE_CHECKSUM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType>("fs.gs.checksum.type", GoogleHadoopFileSystemBase.GcsFileChecksumType.NONE, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_PERFORMANCE_CACHE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.performance.cache.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS = new HadoopConfigurationProperty<Long>("fs.gs.performance.cache.max.entry.age.ms", 5000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_STATUS_PARALLEL_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.status.parallel.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_LAZY_INITIALIZATION_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.lazy.init.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.implicit.dir.repair.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.create.items.conflict.check.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GlobAlgorithm> GCS_GLOB_ALGORITHM = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GlobAlgorithm>("fs.gs.glob.algorithm", GoogleHadoopFileSystemBase.GlobAlgorithm.CONCURRENT, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_MARKER_FILE_PATTERN = new HadoopConfigurationProperty("fs.gs.marker.file.pattern");
    public static final HadoopConfigurationProperty<Long> GCS_MAX_REQUESTS_PER_BATCH = new HadoopConfigurationProperty<Long>("fs.gs.max.requests.per.batch", 15L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_BATCH_THREADS = new HadoopConfigurationProperty<Integer>("fs.gs.batch.threads", 15, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COPY_WITH_REWRITE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.copy.with.rewrite.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_REWRITE_MAX_BYTES_PER_CALL = new HadoopConfigurationProperty<Long>("fs.gs.rewrite.max.bytes.per.call", 0x20000000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_MAX_LIST_ITEMS_PER_CALL = new HadoopConfigurationProperty<Long>("fs.gs.list.max.items.per.call", 5000L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_MAX_RETRY = new HadoopConfigurationProperty<Integer>("fs.gs.http.max.retry", 10, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_CONNECT_TIMEOUT = new HadoopConfigurationProperty<Integer>("fs.gs.http.connect-timeout", 20000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_READ_TIMEOUT = new HadoopConfigurationProperty<Integer>("fs.gs.http.read-timeout", 20000, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_APPLICATION_NAME_SUFFIX = new HadoopConfigurationProperty<String>("fs.gs.application.name.suffix", "", new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE = new HadoopConfigurationProperty<Integer>("fs.gs.max.wait.for.empty.object.creation.ms", 3000, new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType> GCS_OUTPUT_STREAM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType>("fs.gs.outputstream.type", GoogleHadoopFileSystemBase.OutputStreamType.BASIC, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.buffer.size", 0x800000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.pipe.buffer.size", 0x100000, new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.PipeType> GCS_OUTPUT_STREAM_PIPE_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.PipeType>("fs.gs.outputstream.pipe.type", AsyncWriteChannelOptions.PipeType.IO_STREAM_PIPE, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.upload.chunk.size", 0x4000000, "fs.gs.io.buffersize.write");
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.upload.cache.size", 0, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.outputstream.direct.upload.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL_MS = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.sync.min.interval.ms", 0, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.fast.fail.on.not.found.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.support.gzip.encoding.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.inplace.seek.limit", 0x800000L, new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise> GCS_INPUT_STREAM_FADVISE = new HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise>("fs.gs.inputstream.fadvise", GoogleCloudStorageReadOptions.Fadvise.AUTO, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.inputstream.min.range.request.size", 0x200000, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_CHECKSUMS_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.checksums.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_GRPC_SERVER_ADDRESS = new HadoopConfigurationProperty<String>("fs.gs.grpc.server.address", GoogleCloudStorageOptions.DEFAULT_GCS_GRPC_SERVER_ADDRESS, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_CHECK_INTERVAL_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.checkinterval.timeout.ms", 1000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.timeout.ms", 3600000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_MESSAGE_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.message.timeout.ms", 3000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_METADATA_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.metadata.timeout.ms", 60000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_READ_ZEROCOPY_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.read.zerocopy.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_UPLOAD_BUFFERED_REQUESTS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.buffered.requests", 20L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_WRITE_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.timeout.ms", 600000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_WRITE_MESSAGE_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.message.timeout.ms", 3000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_DIRECTPATH_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.directpath.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_TRAFFICDIRECTOR_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.trafficdirector.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COOPERATIVE_LOCKING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.cooperative.locking.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.cooperative.locking.expiration.timeout.ms", CooperativeLockingOptions.LOCK_EXPIRATION_TIMEOUT_MS_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_COOPERATIVE_LOCKING_MAX_CONCURRENT_OPERATIONS = new HadoopConfigurationProperty<Integer>("fs.gs.cooperative.locking.max.concurrent.operations", 20, new String[0]);
    public static final HadoopConfigurationProperty<Map<String, String>> GCS_HTTP_HEADERS = new HadoopConfigurationProperty("fs.gs.storage.http.headers.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_ENCRYPTION_ALGORITHM = new HadoopConfigurationProperty("fs.gs.encryption.algorithm");
    public static final HadoopConfigurationProperty<RedactedString> GCS_ENCRYPTION_KEY = new HadoopConfigurationProperty("fs.gs.encryption.key");
    public static final HadoopConfigurationProperty<RedactedString> GCS_ENCRYPTION_KEY_HASH = new HadoopConfigurationProperty("fs.gs.encryption.key.hash");
    public static final HadoopConfigurationProperty<Class<? extends AuthorizationHandler>> GCS_AUTHORIZATION_HANDLER_IMPL = new HadoopConfigurationProperty("fs.gs.authorization.handler.impl");
    public static final HadoopConfigurationProperty<Map<String, String>> GCS_AUTHORIZATION_HANDLER_PROPERTIES_PREFIX = new HadoopConfigurationProperty("fs.gs.authorization.handler.properties.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageOptions.MetricsSink> GCS_METRICS_SINK = new HadoopConfigurationProperty<GoogleCloudStorageOptions.MetricsSink>("fs.gs.metrics.sink", GoogleCloudStorageOptions.MetricsSink.NONE, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_TRACE_LOG_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.tracelog.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_TRACE_LOG_TIME_THRESHOLD_MS = new HadoopConfigurationProperty<Long>("fs.gs.tracelog.time.filter.threshold.ms", 0L, new String[0]);
    public static final HadoopConfigurationProperty<Collection<String>> GCS_TRACE_LOG_EXCLUDE_PROPERTIES = new HadoopConfigurationProperty("fs.gs.tracelog.exclude.properties", ImmutableList.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageFileSystemOptions.ClientType> GCS_CLIENT_TYPE = new HadoopConfigurationProperty<GoogleCloudStorageFileSystemOptions.ClientType>("fs.gs.client.type", GoogleCloudStorageFileSystemOptions.ClientType.HTTP_API_CLIENT, new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.UploadType> GCS_CLIENT_UPLOAD_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.UploadType>("fs.gs.client.upload.type", AsyncWriteChannelOptions.UploadType.CHUNK_UPLOAD, new String[0]);
    public static final HadoopConfigurationProperty<Collection<String>> GCS_WRITE_TEMPORARY_FILES_PATH = new HadoopConfigurationProperty("fs.gs.write.temporary.dirs", ImmutableSet.of(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_PCU_BUFFER_COUNT = new HadoopConfigurationProperty<Integer>("fs.gs.write.parallel.composite.upload.buffer.count", AsyncWriteChannelOptions.DEFAULT.getPCUBufferCount(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_PCU_BUFFER_CAPACITY = new HadoopConfigurationProperty<Integer>("fs.gs.write.parallel.composite.upload.buffer.capacity", AsyncWriteChannelOptions.DEFAULT.getPCUBufferCapacity(), new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.PartFileCleanupType> GCS_PCU_PART_FILE_CLEANUP_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.PartFileCleanupType>("fs.gs.write.parallel.composite.upload.part.file.cleanup.type", AsyncWriteChannelOptions.DEFAULT.getPartFileCleanupType(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_PCU_PART_FILE_NAME_PREFIX = new HadoopConfigurationProperty<String>("fs.gs.write.parallel.composite.upload.part.file.name.prefix", AsyncWriteChannelOptions.DEFAULT.getPartFileNamePrefix(), new String[0]);

    static GoogleCloudStorageFileSystemOptions.Builder getGcsFsOptionsBuilder(Configuration config) {
        return GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder(config).build()).setClientType(GCS_CLIENT_TYPE.get(config, config::getEnum)).setBucketDeleteEnabled(GCE_BUCKET_DELETE_ENABLE.get(config, config::getBoolean)).setCooperativeLockingEnabled(GCS_COOPERATIVE_LOCKING_ENABLE.get(config, config::getBoolean)).setEnsureNoConflictingItems(GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE.get(config, config::getBoolean)).setMarkerFilePattern(GCS_MARKER_FILE_PATTERN.get(config, config::get)).setPerformanceCacheEnabled(GCS_PERFORMANCE_CACHE_ENABLE.get(config, config::getBoolean)).setPerformanceCacheOptions(GoogleHadoopFileSystemConfiguration.getPerformanceCachingOptions(config)).setStatusParallelEnabled(GCS_STATUS_PARALLEL_ENABLE.get(config, config::getBoolean));
    }

    @VisibleForTesting
    static GoogleCloudStorageOptions.Builder getGcsOptionsBuilder(Configuration config) {
        String projectId = GCS_PROJECT_ID.get(config, config::get);
        return GoogleCloudStorageOptions.builder().setStorageRootUrl(GCS_ROOT_URL.get(config, config::get)).setStorageServicePath(GCS_SERVICE_PATH.get(config, config::get)).setAutoRepairImplicitDirectoriesEnabled(GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.get(config, config::getBoolean)).setCopyWithRewriteEnabled(GCS_COPY_WITH_REWRITE_ENABLE.get(config, config::getBoolean)).setMaxBytesRewrittenPerCall(GCS_REWRITE_MAX_BYTES_PER_CALL.get(config, config::getLong)).setTransportType(HadoopCredentialConfiguration.HTTP_TRANSPORT_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, config::getEnum)).setProxyAddress(HadoopCredentialConfiguration.PROXY_ADDRESS_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, config::get)).setProxyUsername(RedactedString.create(HadoopCredentialConfiguration.PROXY_USERNAME_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config))).setProxyPassword(RedactedString.create(HadoopCredentialConfiguration.PROXY_PASSWORD_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config))).setProjectId(projectId).setMaxListItemsPerCall(GCS_MAX_LIST_ITEMS_PER_CALL.get(config, config::getLong)).setMaxRequestsPerBatch(GCS_MAX_REQUESTS_PER_BATCH.get(config, config::getLong)).setBatchThreads(GCS_BATCH_THREADS.get(config, config::getInt)).setMaxHttpRequestRetries(GCS_HTTP_MAX_RETRY.get(config, config::getInt)).setHttpRequestConnectTimeout(GCS_HTTP_CONNECT_TIMEOUT.get(config, config::getInt)).setHttpRequestReadTimeout(GCS_HTTP_READ_TIMEOUT.get(config, config::getInt)).setAppName(GoogleHadoopFileSystemConfiguration.getApplicationName(config)).setMaxWaitMillisForEmptyObjectCreation(GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE.get(config, config::getInt)).setReadChannelOptions(GoogleHadoopFileSystemConfiguration.getReadChannelOptions(config)).setWriteChannelOptions(GoogleHadoopFileSystemConfiguration.getWriteChannelOptions(config)).setRequesterPaysOptions(GoogleHadoopFileSystemConfiguration.getRequesterPaysOptions(config, projectId)).setCooperativeLockingOptions(GoogleHadoopFileSystemConfiguration.getCooperativeLockingOptions(config)).setHttpRequestHeaders(GCS_HTTP_HEADERS.getPropsWithPrefix(config)).setEncryptionAlgorithm(GCS_ENCRYPTION_ALGORITHM.get(config, config::get)).setEncryptionKey(RedactedString.create(GCS_ENCRYPTION_KEY.getPassword(config))).setEncryptionKeyHash(RedactedString.create(GCS_ENCRYPTION_KEY_HASH.getPassword(config))).setGrpcEnabled(GCS_GRPC_ENABLE.get(config, config::getBoolean)).setAuthorizationHandlerImplClass(GCS_AUTHORIZATION_HANDLER_IMPL.get(config, (k, d) -> config.getClass((String)k, d, AuthorizationHandler.class))).setAuthorizationHandlerProperties(GCS_AUTHORIZATION_HANDLER_PROPERTIES_PREFIX.getPropsWithPrefix(config)).setGrpcServerAddress(GCS_GRPC_SERVER_ADDRESS.get(config, config::get)).setGrpcMessageTimeoutCheckInterval(GCS_GRPC_CHECK_INTERVAL_TIMEOUT_MS.get(config, config::getLong)).setDirectPathPreferred(GCS_GRPC_DIRECTPATH_ENABLE.get(config, config::getBoolean)).setTrafficDirectorEnabled(GCS_GRPC_TRAFFICDIRECTOR_ENABLE.get(config, config::getBoolean)).setMetricsSink(GCS_METRICS_SINK.get(config, config::getEnum)).setTraceLogEnabled(GCS_TRACE_LOG_ENABLE.get(config, config::getBoolean)).setTraceLogTimeThreshold(GCS_TRACE_LOG_TIME_THRESHOLD_MS.get(config, config::getLong)).setTraceLogExcludeProperties(ImmutableSet.copyOf(GCS_TRACE_LOG_EXCLUDE_PROPERTIES.getStringCollection(config)));
    }

    private static PerformanceCachingGoogleCloudStorageOptions getPerformanceCachingOptions(Configuration config) {
        return PerformanceCachingGoogleCloudStorageOptions.builder().setMaxEntryAgeMillis(GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS.get(config, config::getLong)).build();
    }

    private static String getApplicationName(Configuration config) {
        String appNameSuffix = Strings.nullToEmpty(GCS_APPLICATION_NAME_SUFFIX.get(config, config::get));
        String applicationName = GoogleHadoopFileSystem.GHFS_ID + appNameSuffix;
        ((GoogleLogger.Api)logger.atFiner()).log("getApplicationName(config: %s): %s", (Object)config, (Object)applicationName);
        return applicationName;
    }

    private static GoogleCloudStorageReadOptions getReadChannelOptions(Configuration config) {
        return GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.get(config, config::getBoolean)).setSupportGzipEncoding(GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE.get(config, config::getBoolean)).setInplaceSeekLimit(GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.get(config, config::getLong)).setFadvise(GCS_INPUT_STREAM_FADVISE.get(config, config::getEnum)).setMinRangeRequestSize(GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.get(config, config::getInt)).setGrpcChecksumsEnabled(GCS_GRPC_CHECKSUMS_ENABLE.get(config, config::getBoolean)).setGrpcReadTimeoutMillis(GCS_GRPC_READ_TIMEOUT_MS.get(config, config::getLong)).setGrpcReadMessageTimeoutMillis(GCS_GRPC_READ_MESSAGE_TIMEOUT_MS.get(config, config::getLong)).setGrpcReadMetadataTimeoutMillis(GCS_GRPC_READ_METADATA_TIMEOUT_MS.get(config, config::getLong)).setGrpcReadZeroCopyEnabled(GCS_GRPC_READ_ZEROCOPY_ENABLE.get(config, config::getBoolean)).setTraceLogEnabled(GCS_TRACE_LOG_ENABLE.get(config, config::getBoolean)).setTraceLogTimeThreshold(GCS_TRACE_LOG_TIME_THRESHOLD_MS.get(config, config::getLong)).setTraceLogExcludeProperties(ImmutableSet.copyOf(GCS_TRACE_LOG_EXCLUDE_PROPERTIES.getStringCollection(config))).build();
    }

    private static AsyncWriteChannelOptions getWriteChannelOptions(Configuration config) {
        return AsyncWriteChannelOptions.builder().setBufferSize(GCS_OUTPUT_STREAM_BUFFER_SIZE.get(config, config::getInt)).setPipeBufferSize(GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE.get(config, config::getInt)).setPipeType(GCS_OUTPUT_STREAM_PIPE_TYPE.get(config, config::getEnum)).setUploadChunkSize(GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.get(config, config::getInt)).setUploadCacheSize(GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE.get(config, config::getInt)).setDirectUploadEnabled(GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE.get(config, config::getBoolean)).setGrpcChecksumsEnabled(GCS_GRPC_CHECKSUMS_ENABLE.get(config, config::getBoolean)).setGrpcWriteTimeout(GCS_GRPC_WRITE_TIMEOUT_MS.get(config, config::getLong)).setGrpcWriteMessageTimeoutMillis(GCS_GRPC_WRITE_MESSAGE_TIMEOUT_MS.get(config, config::getLong)).setNumberOfBufferedRequests(GCS_GRPC_UPLOAD_BUFFERED_REQUESTS.get(config, config::getLong)).setUploadType(GCS_CLIENT_UPLOAD_TYPE.get(config, config::getEnum)).setTemporaryPaths(ImmutableSet.copyOf(GCS_WRITE_TEMPORARY_FILES_PATH.getStringCollection(config))).setPCUBufferCount(GCS_PCU_BUFFER_COUNT.get(config, config::getInt)).setPCUBufferCapacity(GCS_PCU_BUFFER_CAPACITY.get(config, config::getInt)).setPartFileCleanupType(GCS_PCU_PART_FILE_CLEANUP_TYPE.get(config, config::getEnum)).setPartFileNamePrefix(GCS_PCU_PART_FILE_NAME_PREFIX.get(config, config::get)).build();
    }

    private static RequesterPaysOptions getRequesterPaysOptions(Configuration config, String projectId) {
        String requesterPaysProjectId = GCS_REQUESTER_PAYS_PROJECT_ID.get(config, config::get);
        return RequesterPaysOptions.builder().setMode(GCS_REQUESTER_PAYS_MODE.get(config, config::getEnum)).setProjectId(requesterPaysProjectId == null ? projectId : requesterPaysProjectId).setBuckets(GCS_REQUESTER_PAYS_BUCKETS.getStringCollection(config)).build();
    }

    private static CooperativeLockingOptions getCooperativeLockingOptions(Configuration config) {
        return CooperativeLockingOptions.builder().setLockExpirationTimeoutMilli(GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS.get(config, config::getLong)).setMaxConcurrentOperations(GCS_COOPERATIVE_LOCKING_MAX_CONCURRENT_OPERATIONS.get(config, config::getInt)).build();
    }
}

