/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.metrics.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.common.Scope;
import io.opencensus.exporter.metrics.util.AutoValue_MetricReader_Options;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricProducer;
import io.opencensus.metrics.export.MetricProducerManager;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.samplers.Samplers;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

public class MetricReader {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Logger logger = Logger.getLogger(MetricReader.class.getName());
    private static final Sampler probabilitySampler = Samplers.probabilitySampler(1.0E-4);
    @VisibleForTesting
    static final String DEFAULT_SPAN_NAME = "ExportMetrics";
    private final MetricProducerManager metricProducerManager;
    private final String spanName;

    private MetricReader(MetricProducerManager metricProducerManager, String spanName) {
        this.metricProducerManager = metricProducerManager;
        this.spanName = spanName;
    }

    public static MetricReader create(Options options) {
        Preconditions.checkNotNull(options, "options");
        return new MetricReader(Preconditions.checkNotNull(options.getMetricProducerManager(), "metricProducerManager"), Preconditions.checkNotNull(options.getSpanName(), "spanName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndExport(MetricExporter metricExporter) {
        Span span = tracer.spanBuilder(this.spanName).setRecordEvents(true).setSampler(probabilitySampler).startSpan();
        Scope scope = tracer.withSpan(span);
        try {
            ArrayList<Metric> metricsList = new ArrayList<Metric>();
            for (MetricProducer metricProducer : this.metricProducerManager.getAllMetricProducer()) {
                metricsList.addAll(metricProducer.getMetrics());
            }
            metricExporter.export(metricsList);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception thrown by the metrics exporter.", e);
            span.setStatus(Status.UNKNOWN.withDescription("Exception when export metrics: " + MetricReader.exceptionMessage(e)));
        }
        finally {
            scope.close();
            span.end();
        }
    }

    private static String exceptionMessage(Throwable e) {
        return e.getMessage() != null ? e.getMessage() : e.getClass().getName();
    }

    @Immutable
    public static abstract class Options {
        Options() {
        }

        public abstract MetricProducerManager getMetricProducerManager();

        public abstract String getSpanName();

        public static Builder builder() {
            return new AutoValue_MetricReader_Options.Builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).setSpanName(MetricReader.DEFAULT_SPAN_NAME);
        }

        public static abstract class Builder {
            public abstract Builder setMetricProducerManager(MetricProducerManager var1);

            public abstract Builder setSpanName(String var1);

            public abstract Options build();
        }
    }
}

