/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.util.WatermarkStrategyWithPunctuatedWatermarks;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.sources.wmstrategies.PunctuatedWatermarkAssigner;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.types.Row;

@Internal
public class PunctuatedWatermarkAssignerWrapper
implements WatermarkStrategyWithPunctuatedWatermarks<RowData> {
    private static final long serialVersionUID = 1L;
    private final PunctuatedWatermarkAssigner assigner;
    private final int timeFieldIdx;
    private final DataFormatConverters.DataFormatConverter<RowData, Row> converter;

    public PunctuatedWatermarkAssignerWrapper(PunctuatedWatermarkAssigner assigner, int timeFieldIdx, DataType sourceType) {
        this.assigner = assigner;
        this.timeFieldIdx = timeFieldIdx;
        DataType originDataType = sourceType instanceof FieldsDataType ? sourceType : DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)sourceType)});
        this.converter = DataFormatConverters.getConverterForDataType((DataType)originDataType.bridgedTo(Row.class));
    }

    @Nullable
    public Watermark checkAndGetNextWatermark(RowData row, long extractedTimestamp) {
        long timestamp = row.getLong(this.timeFieldIdx);
        return this.assigner.getWatermark(this.converter.toExternal(row), timestamp);
    }

    public long extractTimestamp(RowData element, long recordTimestamp) {
        return 0L;
    }
}

