/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.wordcount;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.examples.wordcount.util.CLI;
import org.apache.flink.streaming.examples.wordcount.util.WordCountData;
import org.apache.flink.util.Collector;

public class WordCount {
    public static void main(String[] args) throws Exception {
        SingleOutputStreamOperator text;
        Configuration config;
        CLI params = CLI.fromArgs(args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        if (params.isAsyncState() && !(config = Configuration.fromMap((Map)env.getConfiguration().toMap())).containsKey(StateBackendOptions.STATE_BACKEND.key())) {
            config.set(StateBackendOptions.STATE_BACKEND, (Object)"forst");
            env.configure((ReadableConfig)config);
        }
        env.setRuntimeMode(params.getExecutionMode());
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        if (params.getInputs().isPresent()) {
            FileSource.FileSourceBuilder builder = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])params.getInputs().get());
            params.getDiscoveryInterval().ifPresent(x$0 -> {
                FileSource.FileSourceBuilder cfr_ignored_0 = (FileSource.FileSourceBuilder)builder.monitorContinuously(x$0);
            });
            text = env.fromSource((Source)builder.build(), WatermarkStrategy.noWatermarks(), "file-input");
        } else {
            text = env.fromData((Object[])WordCountData.WORDS).name("in-memory-input");
        }
        KeyedStream keyedStream = text.flatMap((FlatMapFunction)new Tokenizer()).name("tokenizer").keyBy((KeySelector & Serializable)value -> (String)value.f0);
        if (params.isAsyncState()) {
            keyedStream.enableAsyncState();
        }
        SingleOutputStreamOperator counts = keyedStream.sum(1).name("counter");
        if (params.getOutput().isPresent()) {
            counts.sinkTo((Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)params.getOutput().get(), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build()).name("file-sink");
        } else {
            counts.print().name("print-sink");
        }
        env.execute("WordCount");
    }

    public static final class Tokenizer
    implements FlatMapFunction<String, Tuple2<String, Integer>> {
        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

