/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public final class ModelReferenceExpression
implements ResolvedExpression {
    private final String name;
    private final ContextResolvedModel model;
    private final TableEnvironment env;

    public ModelReferenceExpression(String name, ContextResolvedModel model, TableEnvironment env) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.model = (ContextResolvedModel)Preconditions.checkNotNull((Object)model);
        this.env = (TableEnvironment)Preconditions.checkNotNull((Object)env);
    }

    public String getName() {
        return this.name;
    }

    public ContextResolvedModel getModel() {
        return this.model;
    }

    @Nullable
    public TableEnvironment getTableEnvironment() {
        return this.env;
    }

    public DataType getInputDataType() {
        return this.model.getResolvedModel().getResolvedInputSchema().toPhysicalRowDataType();
    }

    @Override
    public DataType getOutputDataType() {
        return this.model.getResolvedModel().getResolvedOutputSchema().toPhysicalRowDataType();
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        if (this.model.isAnonymous()) {
            throw new ValidationException("Anonymous models cannot be serialized.");
        }
        return "MODEL " + this.model.getIdentifier().asSerializableString();
    }

    @Override
    public String asSummaryString() {
        return this.name;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelReferenceExpression that = (ModelReferenceExpression)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.model, that.model) && Objects.equals(this.env, that.env);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.model, this.env);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

