/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.hep;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.DelegatingMetadataRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class HepRelVertex
extends AbstractRelNode
implements DelegatingMetadataRel {
    private RelNode currentRel;

    HepRelVertex(RelNode rel) {
        super(rel.getCluster(), rel.getTraitSet());
        this.currentRel = Objects.requireNonNull(rel, "rel");
        Preconditions.checkArgument(!(rel instanceof HepRelVertex));
    }

    @Override
    public void explain(RelWriter pw) {
        this.currentRel.explain(pw);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.equals(this.traitSet));
        assert (inputs.equals(this.getInputs()));
        return this;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeTinyCost();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount(this.currentRel);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.currentRel.getRowType();
    }

    void replaceRel(RelNode newRel) {
        this.currentRel = newRel;
    }

    public RelNode getCurrentRel() {
        return this.currentRel;
    }

    @Override
    public RelNode stripped() {
        return this.currentRel;
    }

    @Override
    public RelNode getMetadataDelegateRel() {
        return this.currentRel;
    }

    @Override
    public boolean deepEquals(@Nullable Object obj) {
        return this == obj || obj instanceof HepRelVertex && this.currentRel == ((HepRelVertex)obj).currentRel;
    }

    @Override
    public int deepHashCode() {
        return this.currentRel.getId();
    }

    @Override
    public String getDigest() {
        return "HepRelVertex(" + this.currentRel + ')';
    }
}

