/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlConvertFunction
extends SqlFunction {
    protected SqlConvertFunction(String name) {
        this(name, SqlKind.CONVERT, ReturnTypes.ARG0, null, null, SqlFunctionCategory.STRING);
    }

    protected SqlConvertFunction(String name, SqlKind kind, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 3);
        operands.get(0).validateExpr(validator, scope);
        assert (operands.get(1) instanceof SqlIdentifier);
        String src_charset = operands.get(1).toString();
        SqlUtil.getCharset(src_charset);
        assert (operands.get(2) instanceof SqlIdentifier);
        String dest_charset = operands.get(2).toString();
        SqlUtil.getCharset(dest_charset);
        super.validateQuantifier(validator, call);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope, (SqlNode)call.operand(0));
        Objects.requireNonNull(nodeType, "nodeType");
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        RelDataType t = callBinding.getOperandType(0);
        if (SqlTypeUtil.isNull(t)) {
            return true;
        }
        if (!SqlTypeUtil.inCharFamily(t)) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.unsupportedTypeInConvertFunc(t.getFullTypeString(), "CONVERT", "CHARACTER"));
            }
            return false;
        }
        return true;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        for (SqlNode node : call.getOperandList()) {
            writer.sep(",");
            node.unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 3: {
                return "{0}({1}, {2}, {3})";
            }
        }
        throw new IllegalStateException("operandsCount should be 3, got " + operandsCount);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(3);
    }
}

