/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeMappingRules;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class FlinkSqlTypeMappingRule
implements SqlTypeMappingRule {
    private static final FlinkSqlTypeMappingRule INSTANCE;
    private final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map;
    public static final ThreadLocal<@Nullable FlinkSqlTypeMappingRule> FLINK_THREAD_PROVIDERS;

    private FlinkSqlTypeMappingRule(Map<SqlTypeName, ImmutableSet<SqlTypeName>> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public static FlinkSqlTypeMappingRule instance() {
        return Objects.requireNonNull(FLINK_THREAD_PROVIDERS.get(), "flinkThreadProviders");
    }

    public static FlinkSqlTypeMappingRule instance(Map<SqlTypeName, ImmutableSet<SqlTypeName>> map) {
        return new FlinkSqlTypeMappingRule(map);
    }

    @Override
    public Map<SqlTypeName, ImmutableSet<SqlTypeName>> getTypeMapping() {
        return this.map;
    }

    static {
        SqlTypeMappingRules.Builder coerceRules = SqlTypeMappingRules.builder();
        coerceRules.addAll(SqlTypeCoercionRule.lenientInstance().getTypeMapping());
        Map<SqlTypeName, ImmutableSet<SqlTypeName>> map = SqlTypeCoercionRule.lenientInstance().getTypeMapping();
        HashSet<SqlTypeName> rule = new HashSet<SqlTypeName>();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.DOUBLE);
        rule.add(SqlTypeName.CHAR);
        rule.add(SqlTypeName.VARCHAR);
        rule.add(SqlTypeName.BOOLEAN);
        rule.add(SqlTypeName.TIMESTAMP);
        rule.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        coerceRules.add(SqlTypeName.FLOAT, rule);
        coerceRules.add(SqlTypeName.DOUBLE, rule);
        coerceRules.add(SqlTypeName.DECIMAL, rule);
        INSTANCE = new FlinkSqlTypeMappingRule(coerceRules.map);
        FLINK_THREAD_PROVIDERS = ThreadLocal.withInitial(() -> INSTANCE);
    }
}

