/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.adaptive;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.table.planner.plan.utils.HashJoinOperatorUtil;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.plan.utils.SorMergeJoinOperatorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.adaptive.AdaptiveJoin;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveJoinOperatorGenerator
implements AdaptiveJoin {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptiveJoinOperatorGenerator.class);
    private final int[] leftKeys;
    private final int[] rightKeys;
    private final FlinkJoinType joinType;
    private final boolean[] filterNulls;
    private final RowType leftType;
    private final RowType rightType;
    private final GeneratedJoinCondition condFunc;
    private final int leftRowSize;
    private final long leftRowCount;
    private final int rightRowSize;
    private final long rightRowCount;
    private final boolean tryDistinctBuildRow;
    private final long managedMemory;
    private final OperatorType originalJoin;
    private boolean leftIsBuild;
    private boolean originalLeftIsBuild;
    private boolean isBroadcastJoin;

    public AdaptiveJoinOperatorGenerator(int[] leftKeys, int[] rightKeys, FlinkJoinType joinType, boolean[] filterNulls, RowType leftType, RowType rightType, GeneratedJoinCondition condFunc, int leftRowSize, int rightRowSize, long leftRowCount, long rightRowCount, boolean tryDistinctBuildRow, long managedMemory, boolean leftIsBuild, OperatorType originalJoin) {
        this.leftKeys = leftKeys;
        this.rightKeys = rightKeys;
        this.joinType = joinType;
        this.filterNulls = filterNulls;
        this.leftType = leftType;
        this.rightType = rightType;
        this.condFunc = condFunc;
        this.leftRowSize = leftRowSize;
        this.rightRowSize = rightRowSize;
        this.leftRowCount = leftRowCount;
        this.rightRowCount = rightRowCount;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        this.managedMemory = managedMemory;
        Preconditions.checkState((originalJoin == OperatorType.ShuffleHashJoin || originalJoin == OperatorType.SortMergeJoin ? 1 : 0) != 0, (Object)String.format("Adaptive join currently only supports adaptive optimization for ShuffleHashJoin and SortMergeJoin, not including %s.", originalJoin.toString()));
        this.leftIsBuild = leftIsBuild;
        this.originalLeftIsBuild = leftIsBuild;
        this.originalJoin = originalJoin;
    }

    public StreamOperatorFactory<?> genOperatorFactory(ClassLoader classLoader, ReadableConfig config) {
        if (this.isBroadcastJoin || this.originalJoin == OperatorType.ShuffleHashJoin) {
            return HashJoinOperatorUtil.generateOperatorFactory(this.leftKeys, this.rightKeys, this.joinType, this.filterNulls, this.leftType, this.rightType, this.condFunc, this.leftIsBuild, this.leftRowSize, this.rightRowSize, this.leftRowCount, this.rightRowCount, this.tryDistinctBuildRow, this.managedMemory, config, classLoader);
        }
        return SorMergeJoinOperatorUtil.generateOperatorFactory(this.condFunc, this.leftType, this.rightType, this.leftKeys, this.rightKeys, this.joinType, config, this.leftIsBuild, this.filterNulls, this.managedMemory, classLoader);
    }

    public FlinkJoinType getJoinType() {
        return this.joinType;
    }

    public void markAsBroadcastJoin(boolean canBroadcast, boolean leftIsBuild) {
        this.isBroadcastJoin = canBroadcast;
        this.leftIsBuild = leftIsBuild;
    }

    public boolean shouldReorderInputs() {
        if (!this.isBroadcastJoin && this.originalJoin == OperatorType.SortMergeJoin) {
            return false;
        }
        if (this.leftIsBuild != this.originalLeftIsBuild) {
            LOG.info("The build side of the adaptive join has been updated. Compile phase build side: {}, Runtime build side: {}.", (Object)(this.originalLeftIsBuild ? "left" : "right"), (Object)(this.leftIsBuild ? "left" : "right"));
        }
        return !this.leftIsBuild;
    }
}

