/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.ml.ModelProvider;

public class RexModelCall
extends RexCall {
    private final ModelProvider modelProvider;
    private final ContextResolvedModel contextResolvedModel;

    public RexModelCall(RelDataType outputType, ContextResolvedModel contextResolvedModel, ModelProvider modelProvider) {
        super(outputType, new SqlSpecialOperator("Model", SqlKind.OTHER), List.of());
        this.contextResolvedModel = contextResolvedModel;
        this.modelProvider = modelProvider;
    }

    public ContextResolvedModel getContextResolvedModel() {
        return this.contextResolvedModel;
    }

    public ModelProvider getModelProvider() {
        return this.modelProvider;
    }

    @Override
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        sb.append("MODEL ").append(this.contextResolvedModel.getIdentifier().asSummaryString()).append(")");
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }
}

