/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ContextResolvedProcedure;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlProcedure;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class FunctionCatalogOperatorTable
implements SqlOperatorTable {
    private final FunctionCatalog functionCatalog;
    private final DataTypeFactory dataTypeFactory;
    private final FlinkTypeFactory typeFactory;
    private final RexFactory rexFactory;

    public FunctionCatalogOperatorTable(FunctionCatalog functionCatalog, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory, RexFactory rexFactory) {
        this.functionCatalog = functionCatalog;
        this.dataTypeFactory = dataTypeFactory;
        this.typeFactory = typeFactory;
        this.rexFactory = rexFactory;
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        if (opName.isStar()) {
            return;
        }
        UnresolvedIdentifier identifier = UnresolvedIdentifier.of(opName.names);
        if (category == SqlFunctionCategory.USER_DEFINED_PROCEDURE) {
            this.functionCatalog.lookupProcedure(identifier).flatMap(this::convertToSqlProcedure).ifPresent(operatorList::add);
        } else {
            this.functionCatalog.lookupFunction(identifier).flatMap(resolvedFunction -> this.convertToSqlFunction(category, (ContextResolvedFunction)resolvedFunction)).ifPresent(operatorList::add);
        }
    }

    private Optional<SqlFunction> convertToSqlProcedure(ContextResolvedProcedure resolvedProcedure) {
        return Optional.of(BridgingSqlProcedure.of(this.dataTypeFactory, resolvedProcedure));
    }

    private Optional<SqlFunction> convertToSqlFunction(@Nullable SqlFunctionCategory category, ContextResolvedFunction resolvedFunction) {
        FunctionDefinition definition = resolvedFunction.getDefinition();
        FunctionIdentifier identifier = resolvedFunction.getIdentifier().orElse(null);
        if (definition instanceof AggregateFunctionDefinition) {
            return this.convertAggregateFunction(identifier, (AggregateFunctionDefinition)definition);
        }
        if (definition instanceof ScalarFunctionDefinition) {
            ScalarFunctionDefinition def = (ScalarFunctionDefinition)definition;
            return this.convertScalarFunction(identifier, def);
        }
        if (definition instanceof TableFunctionDefinition && category != null && category.isTableFunction()) {
            return this.convertTableFunction(identifier, (TableFunctionDefinition)definition);
        }
        return this.convertToBridgingSqlFunction(category, resolvedFunction);
    }

    private Optional<SqlFunction> convertToBridgingSqlFunction(@Nullable SqlFunctionCategory category, ContextResolvedFunction resolvedFunction) {
        TypeInference typeInference;
        FunctionDefinition definition = resolvedFunction.getDefinition();
        if (!this.verifyFunctionKind(category, resolvedFunction)) {
            return Optional.empty();
        }
        try {
            typeInference = definition.getTypeInference(this.dataTypeFactory);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("An error occurred in the type inference logic of function '%s'.", resolvedFunction), t);
        }
        if (typeInference.getOutputTypeStrategy() == TypeStrategies.MISSING) {
            return Optional.empty();
        }
        SqlFunction function = definition.getKind() == FunctionKind.AGGREGATE || definition.getKind() == FunctionKind.TABLE_AGGREGATE ? BridgingSqlAggFunction.of(this.dataTypeFactory, this.typeFactory, SqlKind.OTHER_FUNCTION, resolvedFunction, typeInference) : BridgingSqlFunction.of(this.dataTypeFactory, this.typeFactory, this.rexFactory, SqlKind.OTHER_FUNCTION, resolvedFunction, typeInference);
        return Optional.of(function);
    }

    private boolean verifyFunctionKind(@Nullable SqlFunctionCategory category, ContextResolvedFunction resolvedFunction) {
        BuiltInFunctionDefinition builtInFunction;
        FunctionDefinition definition = resolvedFunction.getDefinition();
        if (definition instanceof BuiltInFunctionDefinition && !(builtInFunction = (BuiltInFunctionDefinition)definition).hasRuntimeImplementation()) {
            return false;
        }
        FunctionKind kind = definition.getKind();
        if (kind == FunctionKind.TABLE || kind == FunctionKind.ASYNC_TABLE || kind == FunctionKind.PROCESS_TABLE) {
            return true;
        }
        if (kind == FunctionKind.SCALAR || kind == FunctionKind.ASYNC_SCALAR || kind == FunctionKind.AGGREGATE || kind == FunctionKind.TABLE_AGGREGATE) {
            if (category != null && category.isTableFunction()) {
                throw new ValidationException(String.format("Function '%s' cannot be used as a table function.", resolvedFunction));
            }
            return true;
        }
        return false;
    }

    private Optional<SqlFunction> convertAggregateFunction(FunctionIdentifier identifier, AggregateFunctionDefinition functionDefinition) {
        SqlFunction aggregateFunction = UserDefinedFunctionUtils.createAggregateSqlFunction(identifier, identifier.toString(), functionDefinition.getAggregateFunction(), TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getAccumulatorTypeInfo()), this.typeFactory);
        return Optional.of(aggregateFunction);
    }

    private Optional<SqlFunction> convertScalarFunction(FunctionIdentifier identifier, ScalarFunctionDefinition functionDefinition) {
        SqlFunction scalarFunction = UserDefinedFunctionUtils.createScalarSqlFunction(identifier, identifier.toString(), functionDefinition.getScalarFunction(), this.typeFactory);
        return Optional.of(scalarFunction);
    }

    private Optional<SqlFunction> convertTableFunction(FunctionIdentifier identifier, TableFunctionDefinition functionDefinition) {
        TableSqlFunction tableFunction = UserDefinedFunctionUtils.createTableSqlFunction(identifier, identifier.toString(), functionDefinition.getTableFunction(), TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getResultType()), this.typeFactory);
        return Optional.of(tableFunction);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        throw new UnsupportedOperationException("This should never be called");
    }
}

