/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import java.time.Duration;
import java.time.ZoneId;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.operators.collect.CollectResultIterator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.operators.collect.CollectStreamSink;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.RuntimeConverter;
import org.apache.flink.table.connector.sink.DataStreamSinkProvider;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.RowDataToStringConverterImpl;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

@Internal
public final class CollectDynamicSink
implements DynamicTableSink {
    private static final String COLLECT_TRANSFORMATION = "collect";
    private final ObjectIdentifier tableIdentifier;
    private final DataType consumedDataType;
    private final MemorySize maxBatchSize;
    private final Duration socketTimeout;
    private final ClassLoader classLoader;
    private final ZoneId sessionZoneId;
    private final boolean legacyCastBehaviour;
    private final ReadableConfig config;
    private CollectResultIterator<RowData> iterator;
    private DynamicTableSink.DataStructureConverter converter;

    CollectDynamicSink(ObjectIdentifier tableIdentifier, DataType consumedDataType, MemorySize maxBatchSize, Duration socketTimeout, ClassLoader classLoader, ZoneId sessionZoneId, boolean legacyCastBehaviour, ReadableConfig config) {
        this.tableIdentifier = tableIdentifier;
        this.consumedDataType = consumedDataType;
        this.maxBatchSize = maxBatchSize;
        this.socketTimeout = socketTimeout;
        this.classLoader = classLoader;
        this.sessionZoneId = sessionZoneId;
        this.legacyCastBehaviour = legacyCastBehaviour;
        this.config = config;
    }

    public ResultProvider getSelectResultProvider() {
        return new CollectResultProvider(new RowDataToStringConverterImpl(this.consumedDataType, this.sessionZoneId, this.classLoader, this.legacyCastBehaviour, new CodeGeneratorContext(this.config, this.classLoader)));
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return requestedMode;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(final DynamicTableSink.Context context) {
        return new DataStreamSinkProvider(){

            public DataStreamSink<?> consumeDataStream(ProviderContext providerContext, DataStream<RowData> inputStream) {
                CheckpointConfig checkpointConfig = inputStream.getExecutionEnvironment().getCheckpointConfig();
                ExecutionConfig config = inputStream.getExecutionConfig();
                TypeSerializer externalSerializer = InternalTypeInfo.of((LogicalType)CollectDynamicSink.this.consumedDataType.getLogicalType()).createSerializer(config.getSerializerConfig());
                String accumulatorName = CollectDynamicSink.this.tableIdentifier.getObjectName();
                CollectSinkOperatorFactory factory = new CollectSinkOperatorFactory(externalSerializer, accumulatorName, CollectDynamicSink.this.maxBatchSize, CollectDynamicSink.this.socketTimeout);
                CollectSinkOperator operator = (CollectSinkOperator)factory.getOperator();
                long resultFetchTimeout = ((Duration)inputStream.getExecutionEnvironment().getConfiguration().get(RpcOptions.ASK_TIMEOUT_DURATION)).toMillis();
                CollectStreamSink sink = new CollectStreamSink(inputStream, factory);
                String operatorUid = (String)((Object)providerContext.generateUid(CollectDynamicSink.COLLECT_TRANSFORMATION).orElse("tableCollectSink_" + sink.getTransformation().getId()));
                CollectDynamicSink.this.iterator = new CollectResultIterator(operatorUid, externalSerializer, accumulatorName, checkpointConfig, resultFetchTimeout);
                CollectDynamicSink.this.converter = context.createDataStructureConverter(CollectDynamicSink.this.consumedDataType);
                CollectDynamicSink.this.converter.open(RuntimeConverter.Context.create((ClassLoader)CollectDynamicSink.this.classLoader));
                sink.uid(operatorUid);
                return sink.name("Collect table sink");
            }
        };
    }

    public DynamicTableSink copy() {
        return new CollectDynamicSink(this.tableIdentifier, this.consumedDataType, this.maxBatchSize, this.socketTimeout, this.classLoader, this.sessionZoneId, this.legacyCastBehaviour, this.config);
    }

    public String asSummaryString() {
        return String.format("TableToCollect(type=%s)", this.consumedDataType);
    }

    private static final class CloseableRowIteratorWrapper<T>
    implements CloseableIterator<T> {
        private final CloseableIterator<RowData> iterator;
        private final Function<RowData, T> mapper;
        private boolean firstRowProcessed = false;

        private CloseableRowIteratorWrapper(CloseableIterator<RowData> iterator, Function<RowData, T> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        public void close() throws Exception {
            this.iterator.close();
        }

        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            this.firstRowProcessed = this.firstRowProcessed || hasNext;
            return hasNext;
        }

        public T next() {
            RowData next = (RowData)this.iterator.next();
            this.firstRowProcessed = true;
            return this.mapper.apply(next);
        }
    }

    private final class CollectResultProvider
    implements ResultProvider {
        private final RowDataToStringConverter rowDataToStringConverter;
        private CloseableRowIteratorWrapper<RowData> rowDataIterator;
        private CloseableRowIteratorWrapper<Row> rowIterator;

        private CollectResultProvider(RowDataToStringConverter rowDataToStringConverter) {
            this.rowDataToStringConverter = rowDataToStringConverter;
        }

        public ResultProvider setJobClient(JobClient jobClient) {
            CollectDynamicSink.this.iterator.setJobClient(jobClient);
            return this;
        }

        public CloseableIterator<RowData> toInternalIterator() {
            if (this.rowDataIterator == null) {
                this.rowDataIterator = new CloseableRowIteratorWrapper((CloseableIterator<RowData>)CollectDynamicSink.this.iterator, Function.identity());
            }
            return this.rowDataIterator;
        }

        public CloseableIterator<Row> toExternalIterator() {
            if (this.rowIterator == null) {
                this.rowIterator = new CloseableRowIteratorWrapper<Row>((CloseableIterator<RowData>)CollectDynamicSink.this.iterator, r -> (Row)CollectDynamicSink.this.converter.toExternal(r));
            }
            return this.rowIterator;
        }

        public RowDataToStringConverter getRowDataStringConverter() {
            return this.rowDataToStringConverter;
        }

        public boolean isFirstRowReady() {
            return this.rowDataIterator != null && this.rowDataIterator.firstRowProcessed || this.rowIterator != null && this.rowIterator.firstRowProcessed || CollectDynamicSink.this.iterator.hasNext();
        }

        public void reset() {
            CollectDynamicSink.this.iterator = CollectDynamicSink.this.iterator.copy();
            this.rowDataIterator = null;
            this.rowIterator = null;
        }
    }
}

