/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.nio.charset.StandardCharsets;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.utils.EncodingUtils;

class BinaryToStringCastRule
extends AbstractNullAwareCodeGeneratorCastRule<byte[], String> {
    static final BinaryToStringCastRule INSTANCE = new BinaryToStringCastRule();

    private BinaryToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.BINARY_STRING).target(LogicalTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        String resultStringTerm = CodeGenUtils.newName(context.getCodeGeneratorContext(), "resultString");
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter();
        writer.declStmt(String.class, resultStringTerm);
        if (context.isPrinting()) {
            writer.assignStmt(resultStringTerm, "\"x'\"").assignPlusStmt(resultStringTerm, CastRuleUtils.staticCall(EncodingUtils.class, "hex", inputTerm)).assignPlusStmt(resultStringTerm, "\"'\"");
        } else {
            writer.assignStmt(resultStringTerm, CastRuleUtils.constructorCall(String.class, inputTerm, CastRuleUtils.accessStaticField(StandardCharsets.class, "UTF_8")));
        }
        if (!context.legacyBehaviour() && !context.isPrinting()) {
            String resultPadOrTrim = CodeGenUtils.newName(context.getCodeGeneratorContext(), "resultPadOrTrim");
            int length = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
            CharVarCharTrimPadCastRule.padAndTrimStringIfNeeded(writer, targetLogicalType, context.legacyBehaviour(), length, resultPadOrTrim, resultStringTerm, context.getCodeGeneratorContext());
            writer.assignStmt(resultStringTerm, resultPadOrTrim);
        }
        return writer.assignStmt(returnVariable, CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), resultStringTerm)).toString();
    }
}

