/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rex.RexLiteral;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class FunctionCallContext
extends AbstractSqlCallContext {
    private final List<FunctionCallUtil.FunctionParam> params;
    private final List<DataType> argumentDataTypes;
    private final DataType outputDataType;

    public FunctionCallContext(DataTypeFactory dataTypeFactory, UserDefinedFunction function, final LogicalType inputType, final List<FunctionCallUtil.FunctionParam> params, LogicalType outputDataType) {
        super(dataTypeFactory, (FunctionDefinition)function, UserDefinedFunctionHelper.generateInlineFunctionName((UserDefinedFunction)function), false);
        this.params = params;
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int index) {
                LogicalType keyType;
                FunctionCallUtil.FunctionParam key = FunctionCallContext.this.getKey(index);
                if (key instanceof FunctionCallUtil.Constant) {
                    keyType = ((FunctionCallUtil.Constant)key).sourceType;
                } else if (key instanceof FunctionCallUtil.FieldRef) {
                    keyType = (LogicalType)LogicalTypeChecks.getFieldTypes((LogicalType)inputType).get(((FunctionCallUtil.FieldRef)key).index);
                } else {
                    throw new IllegalArgumentException();
                }
                return TypeConversions.fromLogicalToDataType((LogicalType)keyType);
            }

            @Override
            public int size() {
                return params.size();
            }
        };
        this.outputDataType = TypeConversions.fromLogicalToDataType((LogicalType)outputDataType);
    }

    public boolean isArgumentLiteral(int pos) {
        return this.getKey(pos) instanceof FunctionCallUtil.Constant;
    }

    public boolean isArgumentNull(int pos) {
        FunctionCallUtil.Constant key = (FunctionCallUtil.Constant)this.getKey(pos);
        return key.literal.isNull();
    }

    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        try {
            FunctionCallUtil.Constant key = (FunctionCallUtil.Constant)this.getKey(pos);
            RexLiteral literal = key.literal;
            return Optional.ofNullable(FunctionCallContext.getLiteralValueAs(literal::getValueAs, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    public Optional<DataType> getOutputDataType() {
        return Optional.of(this.outputDataType);
    }

    private FunctionCallUtil.FunctionParam getKey(int pos) {
        return this.params.get(pos);
    }
}

