/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.hint.QueryHintsRelShuttle;

public class ClearQueryHintsWithInvalidPropagationShuttle
extends QueryHintsRelShuttle {
    @Override
    protected RelNode doVisit(RelNode node) {
        ImmutableList<RelHint> hints = ((Hintable)((Object)node)).getHints();
        Set allHintNames = hints.stream().map(hint -> hint.hintName).collect(Collectors.toSet());
        if (allHintNames.stream().noneMatch(FlinkHints::isQueryHint)) {
            return super.visit(node);
        }
        Optional<RelHint> firstAliasHint = hints.stream().filter(hint -> "ALIAS".equals(hint.hintName)).findFirst();
        if (!firstAliasHint.isPresent()) {
            return super.visit(node);
        }
        List queryHintsFromOuterQueryBlock = hints.stream().filter(hint -> FlinkHints.isQueryHint(hint.hintName) && hint.inheritPath.size() > ((RelHint)firstAliasHint.get()).inheritPath.size()).collect(Collectors.toList());
        if (queryHintsFromOuterQueryBlock.isEmpty()) {
            return super.visit(node);
        }
        RelNode newRelNode = node;
        for (RelHint outerQueryHint : queryHintsFromOuterQueryBlock) {
            ClearOuterQueryHintShuttle clearOuterQueryHintShuttle = new ClearOuterQueryHintShuttle(outerQueryHint);
            newRelNode = newRelNode.accept(clearOuterQueryHintShuttle);
        }
        return super.visit(newRelNode);
    }

    private static class ClearOuterQueryHintShuttle
    extends RelShuttleImpl {
        private final Deque<Integer> currentInheritPath;
        private final RelHint queryHintNeedRemove;

        public ClearOuterQueryHintShuttle(RelHint queryHintNeedRemove) {
            this.queryHintNeedRemove = queryHintNeedRemove;
            this.currentInheritPath = new ArrayDeque<Integer>();
            this.currentInheritPath.addAll(queryHintNeedRemove.inheritPath);
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode child) {
            this.currentInheritPath.addLast(i);
            RelNode newNode = super.visitChild(parent, i, child);
            this.currentInheritPath.removeLast();
            return newNode;
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            return this.doVisit(correlate);
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            return this.doVisit(join);
        }

        @Override
        public RelNode visit(LogicalAggregate aggregate) {
            return this.doVisit(aggregate);
        }

        private RelNode doVisit(RelNode node) {
            Hintable hNode = (Hintable)((Object)node);
            ArrayList<RelHint> hints = new ArrayList<RelHint>(hNode.getHints());
            Optional<RelHint> invalidQueryHint = this.getInvalidQueryHint(hints);
            if (invalidQueryHint.isPresent()) {
                hints.remove(invalidQueryHint.get());
                return super.visit(hNode.withHints(hints));
            }
            return super.visit(node);
        }

        private Optional<RelHint> getInvalidQueryHint(List<RelHint> hints) {
            for (RelHint hint : hints) {
                if (!hint.hintName.equals(this.queryHintNeedRemove.hintName) || !this.isMatchInvalidInheritPath(new ArrayList<Integer>(this.currentInheritPath), hint.inheritPath)) continue;
                return Optional.of(hint);
            }
            return Optional.empty();
        }

        private boolean isMatchInvalidInheritPath(List<Integer> invalidInheritPath, List<Integer> checkedInheritPath) {
            if (invalidInheritPath.size() != checkedInheritPath.size()) {
                return false;
            }
            for (int i = 0; i < invalidInheritPath.size(); ++i) {
                if (Objects.equals(invalidInheritPath.get(i), checkedInheritPath.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

