/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import org.apache.flink.sql.parser.ddl.SqlAlterModelRename;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterModelRenameOperation;
import org.apache.flink.table.planner.operations.converters.AbstractSqlAlterModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlAlterModelRenameConverter
extends AbstractSqlAlterModelConverter<SqlAlterModelRename> {
    @Override
    public Operation convertSqlNode(SqlAlterModelRename sqlAlterModelRename, SqlNodeConverter.ConvertContext context) {
        this.getExistingModel(context, sqlAlterModelRename.fullModelName(), sqlAlterModelRename.ifModelExists());
        UnresolvedIdentifier newUnresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterModelRename.fullNewModelName());
        ObjectIdentifier newModelIdentifier = context.getCatalogManager().qualifyIdentifier(newUnresolvedIdentifier);
        ObjectIdentifier oldModelIdentifier = context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])sqlAlterModelRename.fullModelName()));
        if (!newModelIdentifier.getCatalogName().equals(oldModelIdentifier.getCatalogName())) {
            throw new ValidationException(String.format("The catalog name of the new model name '%s' must be the same as the old model name '%s'.", newModelIdentifier.asSummaryString(), oldModelIdentifier.asSummaryString()));
        }
        return new AlterModelRenameOperation(oldModelIdentifier, newModelIdentifier, sqlAlterModelRename.ifModelExists());
    }
}

