/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.sql.parser.ddl.SqlAlterModelReset;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ModelChange;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterModelChangeOperation;
import org.apache.flink.table.planner.operations.converters.AbstractSqlAlterModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlAlterModelResetConverter
extends AbstractSqlAlterModelConverter<SqlAlterModelReset> {
    @Override
    public Operation convertSqlNode(SqlAlterModelReset sqlAlterModelReset, SqlNodeConverter.ConvertContext context) {
        ResolvedCatalogModel existingModel = this.getExistingModel(context, sqlAlterModelReset.fullModelName(), sqlAlterModelReset.ifModelExists());
        Set<String> resetKeys = sqlAlterModelReset.getResetKeys();
        if (resetKeys.isEmpty()) {
            throw new ValidationException("ALTER MODEL RESET does not support empty key.");
        }
        List modelChanges = resetKeys.stream().map(ModelChange::reset).collect(Collectors.toList());
        if (existingModel == null) {
            return new AlterModelChangeOperation(context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])sqlAlterModelReset.fullModelName())), modelChanges, null, sqlAlterModelReset.ifModelExists());
        }
        HashMap newOptions = new HashMap(existingModel.getOptions());
        resetKeys.forEach(newOptions::remove);
        return new AlterModelChangeOperation(context.getCatalogManager().qualifyIdentifier(UnresolvedIdentifier.of((String[])sqlAlterModelReset.fullModelName())), modelChanges, existingModel.copy(newOptions), sqlAlterModelReset.ifModelExists());
    }
}

