/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SqlAlterCatalogCommentConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterCatalogOptionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterCatalogResetConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableAddDistributionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableAsQueryConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableDropDistributionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableModifyDistributionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableRefreshConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableResumeConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableSuspendConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterModelRenameConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterModelResetConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterModelSetConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewAsConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewPropertiesConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewRenameConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateMaterializedTableConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateViewConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeFunctionConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeJobConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlDropMaterializedTableConverter;
import org.apache.flink.table.planner.operations.converters.SqlDropModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.SqlProcedureCallConverter;
import org.apache.flink.table.planner.operations.converters.SqlQueryConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowCatalogsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowCreateCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowCreateModelConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowDatabasesConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowFunctionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowModelsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowPartitionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowProcedureConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableAddPartitionConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableDropColumnConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableDropConstraintConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableDropDistributionConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableDropPartitionConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableDropPrimaryKeyConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableDropWatermarkConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableOptionsConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableRenameColumnConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableRenameConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableResetConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableSchemaAddConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlAlterTableSchemaModifyConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlCreateTableAsConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlCreateTableConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlCreateTableLikeConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlReplaceTableAsConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlShowTablesConverter;
import org.apache.flink.table.planner.operations.converters.table.SqlTruncateTableConverter;

public class SqlNodeConverters {
    private static final Map<Class<?>, SqlNodeConverter<?>> CLASS_CONVERTERS = new HashMap();
    private static final Map<SqlKind, SqlNodeConverter<?>> SQLKIND_CONVERTERS = new HashMap();

    public static Optional<Operation> convertSqlNode(SqlNode validatedSqlNode, SqlNodeConverter.ConvertContext context) {
        SqlNodeConverter<?> classConverter = CLASS_CONVERTERS.get(validatedSqlNode.getClass());
        if (classConverter != null) {
            return Optional.of(classConverter.convertSqlNode(validatedSqlNode, context));
        }
        SqlNodeConverter<?> sqlKindConverter = SQLKIND_CONVERTERS.get((Object)validatedSqlNode.getKind());
        if (sqlKindConverter != null) {
            return Optional.of(sqlKindConverter.convertSqlNode(validatedSqlNode, context));
        }
        return Optional.empty();
    }

    private static void register(SqlNodeConverter<?> converter) {
        if (converter.supportedSqlKinds().isPresent()) {
            for (SqlKind sqlKind : converter.supportedSqlKinds().get()) {
                if (SQLKIND_CONVERTERS.containsKey((Object)sqlKind)) {
                    throw new IllegalArgumentException(String.format("Failed to register converter for '%s', because there is a registered converter for the SqlKind '%s'", new Object[]{converter.getClass().getCanonicalName(), sqlKind}));
                }
                SQLKIND_CONVERTERS.put(sqlKind, converter);
            }
            return;
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(converter, SqlNodeConverter.class, converter.getClass(), (int)0);
        Class nodeClass = typeInfo.getTypeClass();
        if (CLASS_CONVERTERS.containsKey(nodeClass)) {
            throw new IllegalArgumentException(String.format("Failed to register converter for '%s', because there is a registered converter for the SqlNode '%s'", converter.getClass().getCanonicalName(), nodeClass.getCanonicalName()));
        }
        CLASS_CONVERTERS.put(nodeClass, converter);
    }

    static {
        SqlNodeConverters.register(new SqlCreateCatalogConverter());
        SqlNodeConverters.register(new SqlAlterCatalogOptionsConverter());
        SqlNodeConverters.register(new SqlAlterCatalogResetConverter());
        SqlNodeConverters.register(new SqlAlterCatalogCommentConverter());
        SqlNodeConverters.register(new SqlCreateViewConverter());
        SqlNodeConverters.register(new SqlAlterViewRenameConverter());
        SqlNodeConverters.register(new SqlAlterViewPropertiesConverter());
        SqlNodeConverters.register(new SqlAlterViewAsConverter());
        SqlNodeConverters.register(new SqlAlterTableAddPartitionConverter());
        SqlNodeConverters.register(new SqlAlterTableDropPartitionConverter());
        SqlNodeConverters.register(new SqlQueryConverter());
        SqlNodeConverters.register(new SqlShowPartitionsConverter());
        SqlNodeConverters.register(new SqlTruncateTableConverter());
        SqlNodeConverters.register(new SqlShowFunctionsConverter());
        SqlNodeConverters.register(new SqlShowModelsConverter());
        SqlNodeConverters.register(new SqlShowCreateModelConverter());
        SqlNodeConverters.register(new SqlShowProcedureConverter());
        SqlNodeConverters.register(new SqlReplaceTableAsConverter());
        SqlNodeConverters.register(new SqlProcedureCallConverter());
        SqlNodeConverters.register(new SqlShowDatabasesConverter());
        SqlNodeConverters.register(new SqlShowCreateCatalogConverter());
        SqlNodeConverters.register(new SqlDescribeCatalogConverter());
        SqlNodeConverters.register(new SqlDescribeJobConverter());
        SqlNodeConverters.register(new SqlCreateMaterializedTableConverter());
        SqlNodeConverters.register(new SqlCreateModelConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableRefreshConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableSuspendConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableResumeConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableAsQueryConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableAddDistributionConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableModifyDistributionConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableDropDistributionConverter());
        SqlNodeConverters.register(new SqlAlterModelRenameConverter());
        SqlNodeConverters.register(new SqlAlterModelResetConverter());
        SqlNodeConverters.register(new SqlAlterModelSetConverter());
        SqlNodeConverters.register(new SqlDropMaterializedTableConverter());
        SqlNodeConverters.register(new SqlDropModelConverter());
        SqlNodeConverters.register(new SqlShowTablesConverter());
        SqlNodeConverters.register(new SqlShowCatalogsConverter());
        SqlNodeConverters.register(new SqlDescribeFunctionConverter());
        SqlNodeConverters.register(new SqlDescribeModelConverter());
        SqlNodeConverters.register(new SqlCreateTableAsConverter());
        SqlNodeConverters.register(new SqlCreateTableConverter());
        SqlNodeConverters.register(new SqlCreateTableLikeConverter());
        SqlNodeConverters.register(new SqlAlterTableDropPrimaryKeyConverter());
        SqlNodeConverters.register(new SqlAlterTableDropColumnConverter());
        SqlNodeConverters.register(new SqlAlterTableDropConstraintConverter());
        SqlNodeConverters.register(new SqlAlterTableDropWatermarkConverter());
        SqlNodeConverters.register(new SqlAlterTableDropDistributionConverter());
        SqlNodeConverters.register(new SqlAlterTableRenameColumnConverter());
        SqlNodeConverters.register(new SqlAlterTableResetConverter());
        SqlNodeConverters.register(new SqlAlterTableOptionsConverter());
        SqlNodeConverters.register(new SqlAlterTableSchemaModifyConverter());
        SqlNodeConverters.register(new SqlAlterTableSchemaAddConverter());
        SqlNodeConverters.register(new SqlAlterTableRenameConverter());
    }
}

