/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import javax.annotation.Nullable;
import org.apache.flink.sql.parser.dql.SqlShowTables;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowMaterializedTablesOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;
import org.apache.flink.table.planner.operations.converters.AbstractSqlShowConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlShowTablesConverter
extends AbstractSqlShowConverter<SqlShowTables> {
    @Override
    public Operation getOperationWithoutPrep(SqlShowTables sqlShowCall, @Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        switch (sqlShowCall.getTableKind()) {
            case MATERIALIZED_TABLE: {
                return new ShowMaterializedTablesOperation(catalogName, databaseName, likeOp);
            }
            case TABLE: {
                return new ShowTablesOperation(catalogName, databaseName, likeOp);
            }
            case VIEW: {
                return new ShowViewsOperation(catalogName, databaseName, likeOp);
            }
        }
        throw new ValidationException("Not supported table kind " + String.valueOf((Object)sqlShowCall.getTableKind()) + " yet");
    }

    @Override
    public Operation getOperation(SqlShowTables sqlShowCall, @Nullable String catalogName, @Nullable String databaseName, String prep, @Nullable ShowLikeOperator likeOp) {
        switch (sqlShowCall.getTableKind()) {
            case MATERIALIZED_TABLE: {
                return new ShowMaterializedTablesOperation(catalogName, databaseName, prep, likeOp);
            }
            case TABLE: {
                return new ShowTablesOperation(catalogName, databaseName, prep, likeOp);
            }
            case VIEW: {
                return new ShowViewsOperation(catalogName, databaseName, prep, likeOp);
            }
        }
        throw new ValidationException("Not supported table kind " + String.valueOf((Object)sqlShowCall.getTableKind()) + " yet");
    }

    @Override
    public Operation convertSqlNode(SqlShowTables sqlShowTables, SqlNodeConverter.ConvertContext context) {
        return this.convertShowOperation(sqlShowTables, context);
    }
}

