/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.parse;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.planner.parse.AbstractRegexParseStrategy;

public class SetOperationParseStrategy
extends AbstractRegexParseStrategy {
    static final SetOperationParseStrategy INSTANCE = new SetOperationParseStrategy();

    protected SetOperationParseStrategy() {
        super(Pattern.compile("SET(\\s+(?<key>[^'\\s]+)\\s*=\\s*('(?<quotedVal>[^']*)'|(?<val>[^;\\s]+)))?\\s*;?", 34));
    }

    @Override
    public Operation convert(String statement) {
        Matcher matcher = this.pattern.matcher(statement.trim());
        ArrayList<String> operands = new ArrayList<String>();
        if (matcher.find() && matcher.group("key") != null) {
            operands.add(matcher.group("key"));
            operands.add(matcher.group("quotedVal") != null ? matcher.group("quotedVal") : matcher.group("val"));
        }
        if (operands.isEmpty()) {
            return new SetOperation();
        }
        if (operands.size() == 2) {
            return new SetOperation((String)operands.get(0), (String)operands.get(1));
        }
        throw new TableException(String.format("Failed to convert the statement to SET operation: %s.", statement));
    }

    @Override
    public String[] getHints() {
        return new String[]{"SET"};
    }
}

