/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.dynamicfiltering.ExecutionOrderEnforcerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.generator.TwoInputOpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.spec.ExecutionOrderEnforcerFusionCodegenSpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecDynamicFilteringDataCollector;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.operators.dynamicfiltering.DynamicFilteringDataCollectorOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecExecutionOrderEnforcer
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    public BatchExecExecutionOrderEnforcer(ReadableConfig tableConfig, List<InputProperty> inputProperties, LogicalType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecExecutionOrderEnforcer.class), ExecNodeContext.newPersistedConfig(BatchExecExecutionOrderEnforcer.class, tableConfig), inputProperties, outputType, description);
    }

    @Override
    public boolean supportFusionCodegen() {
        return true;
    }

    @Override
    protected OpFusionCodegenSpecGenerator translateToFusionCodegenSpecInternal(PlannerBase planner, ExecNodeConfig config, CodeGeneratorContext parentCtx) {
        OpFusionCodegenSpecGenerator leftInput = this.getInputEdges().get(0).translateToFusionCodegenSpec(planner, parentCtx);
        OpFusionCodegenSpecGenerator rightInput = this.getInputEdges().get(1).translateToFusionCodegenSpec(planner, parentCtx);
        TwoInputOpFusionCodegenSpecGenerator runtimeFilterGenerator = new TwoInputOpFusionCodegenSpecGenerator(leftInput, rightInput, 0L, (RowType)this.getOutputType(), new ExecutionOrderEnforcerFusionCodegenSpec(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader(), parentCtx)));
        leftInput.addOutput(1, runtimeFilterGenerator);
        rightInput.addOutput(2, runtimeFilterGenerator);
        return runtimeFilterGenerator;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<?> dynamicFilteringInputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        Transformation<?> sourceTransform = this.getInputEdges().get(1).translateToPlan(planner);
        BatchExecDynamicFilteringDataCollector dynamicFilteringDataCollector = (BatchExecDynamicFilteringDataCollector)BatchExecExecutionOrderEnforcer.ignoreExchange(this.getInputEdges().get(0).getSource());
        BatchExecTableSourceScan tableSourceScan = (BatchExecTableSourceScan)this.getInputEdges().get(1).getSource();
        ((SourceTransformation)sourceTransform).setCoordinatorListeningID(tableSourceScan.getDynamicFilteringDataListenerID());
        ((DynamicFilteringDataCollectorOperatorFactory)((OneInputTransformation)dynamicFilteringDataCollector.translateToPlan(planner)).getOperatorFactory()).registerDynamicFilteringDataListenerID(tableSourceScan.getDynamicFilteringDataListenerID());
        CodeGenOperatorFactory<RowData> operatorFactory = ExecutionOrderEnforcerCodeGenerator.gen(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), (RowType)this.getInputEdges().get(0).getOutputType(), (RowType)this.getInputEdges().get(1).getOutputType());
        return ExecNodeUtil.createTwoInputTransformation(dynamicFilteringInputTransform, sourceTransform, this.createTransformationName(config), this.createTransformationDescription(config), operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), sourceTransform.getParallelism(), 0L, false);
    }

    private static ExecNode<?> ignoreExchange(ExecNode<?> execNode) {
        if (execNode instanceof BatchExecExchange) {
            return execNode.getInputEdges().get(0).getSource();
        }
        return execNode;
    }
}

