/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
final class DataTypeJsonSerializer
extends StdSerializer<DataType> {
    private static final long serialVersionUID = 1L;
    static final String FIELD_NAME_TYPE = "logicalType";
    static final String FIELD_NAME_CONVERSION_CLASS = "conversionClass";
    static final String FIELD_NAME_ELEMENT_CLASS = "elementClass";
    static final String FIELD_NAME_KEY_CLASS = "keyClass";
    static final String FIELD_NAME_VALUE_CLASS = "valueClass";
    static final String FIELD_NAME_FIELDS = "fields";
    static final String FIELD_NAME_FIELD_NAME = "name";

    DataTypeJsonSerializer() {
        super(DataType.class);
    }

    public void serialize(DataType dataType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (DataTypeUtils.isDefaultClassNested((DataType)dataType)) {
            serializerProvider.defaultSerializeValue((Object)dataType.getLogicalType(), jsonGenerator);
        } else {
            jsonGenerator.writeStartObject();
            serializerProvider.defaultSerializeField(FIELD_NAME_TYPE, (Object)dataType.getLogicalType(), jsonGenerator);
            DataTypeJsonSerializer.serializeClass(dataType, jsonGenerator);
            jsonGenerator.writeEndObject();
        }
    }

    private static void serializeClass(DataType dataType, JsonGenerator jsonGenerator) throws IOException {
        if (!DataTypeUtils.isDefaultClass((DataType)dataType)) {
            jsonGenerator.writeStringField(FIELD_NAME_CONVERSION_CLASS, dataType.getConversionClass().getName());
        }
        if (DataTypeUtils.isInternal((DataType)dataType, (boolean)false)) {
            return;
        }
        switch (dataType.getLogicalType().getTypeRoot()) {
            case ARRAY: 
            case MULTISET: {
                CollectionDataType collectionDataType = (CollectionDataType)dataType;
                DataTypeJsonSerializer.serializeFieldIfNotDefaultClass(collectionDataType.getElementDataType(), FIELD_NAME_ELEMENT_CLASS, jsonGenerator);
                break;
            }
            case MAP: {
                KeyValueDataType keyValueDataType = (KeyValueDataType)dataType;
                DataTypeJsonSerializer.serializeFieldIfNotDefaultClass(keyValueDataType.getKeyDataType(), FIELD_NAME_KEY_CLASS, jsonGenerator);
                DataTypeJsonSerializer.serializeFieldIfNotDefaultClass(keyValueDataType.getValueDataType(), FIELD_NAME_VALUE_CLASS, jsonGenerator);
                break;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                List nonDefaultFields = DataType.getFields((DataType)dataType).stream().filter(field -> !DataTypeUtils.isDefaultClassNested((DataType)field.getDataType())).collect(Collectors.toList());
                if (nonDefaultFields.isEmpty()) break;
                jsonGenerator.writeFieldName(FIELD_NAME_FIELDS);
                jsonGenerator.writeStartArray();
                for (DataTypes.Field nonDefaultField : nonDefaultFields) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField(FIELD_NAME_FIELD_NAME, nonDefaultField.getName());
                    DataTypeJsonSerializer.serializeClass(nonDefaultField.getDataType(), jsonGenerator);
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                break;
            }
            case DISTINCT_TYPE: {
                DataType sourceDataType = (DataType)dataType.getChildren().get(0);
                if (DataTypeUtils.isDefaultClassNested((DataType)sourceDataType)) break;
                DataTypeJsonSerializer.serializeClass(sourceDataType, jsonGenerator);
                break;
            }
        }
    }

    private static void serializeFieldIfNotDefaultClass(DataType dataType, String fieldName, JsonGenerator jsonGenerator) throws IOException {
        if (!DataTypeUtils.isDefaultClassNested((DataType)dataType)) {
            jsonGenerator.writeFieldName(fieldName);
            jsonGenerator.writeStartObject();
            DataTypeJsonSerializer.serializeClass(dataType, jsonGenerator);
            jsonGenerator.writeEndObject();
        }
    }
}

